'use server'
import { prisma } from '@/lib/db';


export async function createTestimonials(values: any) {
    const userRating = Number.parseInt(values.rating)
    try {
        const testimonials = await prisma.testimonials.create({
            data: {
                name: values.name,
                designation: values.designation,
                message: values.message,
                rating: userRating
            }
        })
        return { testimonials }
    } catch (error) {
        return { error: "Unable to create Testimonials" }
    }

}

export async function getAllTestimonials() {
    try {
        const testimonials = await prisma.testimonials.findMany({
            orderBy: {
                createdAt: "desc"
            }
        })
        return { testimonials }

    } catch (error) {
        return { error: "Unable to fetch All Companies" }
    }
}

export async function deleteCompanyById(id: string) {
    try {

        const deleted = await prisma.company.delete({
            where: {
                id: id
            }
        })

        if (deleted) {
            return { success: "Company Deleted Successfully" }
        }
    } catch (error) {
        return { error: "Unable to Delete Company" }
    }
}