'use server'

import { prisma } from "@/lib/db"

export async function createsection(values: any, id: string) {
    try {
        const created = await prisma.section.create({
            data: {
                courseId: id,
                title: values.title

            }
        });

        const section = await prisma.section.findUnique({
            where: { id: created.id },
            include: {
                lesson: true
            }
        });

        return { section }; // Ensure it returns a single object
    } catch (error) {
        return { error: "Unable to Create section" };
    }
}

export async function updatesectionById(values: any, id: string, courseId: string) {
    try {
        const updated = await prisma.section.update({
            where: { id },
            data: {
                courseId: courseId,
                title: values.title
            }
        });

        const section = await prisma.section.findUnique({
            where: { id },
            include: {
                lesson: true
            }
        });

        return { section }; // Ensure it returns a single object
    } catch (error) {
        return { error: "Unable to Update section" };
    }
}

export async function deletesectionById(id: string) {
    try {
        const section = await prisma.section.delete({
            where: { id },
        });

        return { success: "Section deleted successfully" };
    } catch (error) {
        console.log("Error deleting section:", error); // Log actual error
        return { error: "Unable to delete section" }; // ✅ Correct error message
    }
}



