'use server'

import { prisma } from "@/lib/db"

export async function createLesson(values: any, id: string) {
    try {
        const created = await prisma.lesson.create({
            data: {
                sectionId: id,
                title: values.title,
                content: values.content,
                videoUrl: values.videoUrl

            }
        });

        const lesson = await prisma.lesson.findUnique({
            where: { id: created.id },

        });

        return { lesson }; // Ensure it returns a single object
    } catch (error) {
        return { error: "Unable to Create section" };
    }
}

export async function getLessons(id: string) {
    try {


        const lesson = await prisma.lesson.findMany({
            where: { sectionId: id },
            orderBy: {
                createdAt: "asc"
            }
        });

        return { lesson }; // Ensure it returns a single object
    } catch (error) {
        return { error: "Unable to fetch lessons" };
    }
}

export async function updateLessonById(values: any, id: string,) {
    try {
        const updated = await prisma.lesson.update({
            where: { id },
            data: {
                title: values.title,
                content: values.content,
                videoUrl: values.videoUrl
            }
        });

        const lesson = await prisma.lesson.findUnique({
            where: { id: updated.id },

        });

        return { lesson }; // Ensure it returns a single object
    } catch (error) {
        return { error: "Unable to Update section" };
    }
}

export async function deleteLessonById(id: string) {
    try {
        const section = await prisma.lesson.delete({
            where: { id },
        });

        return { success: "Section deleted successfully" };
    } catch (error) {
        console.log("Error deleting section:", error); // Log actual error
        return { error: "Unable to delete section" }; // ✅ Correct error message
    }
}



