"use server"
import { prisma } from "@/lib/db"
import { promises as fs } from "fs"
import { join } from "path"

export async function createGallery(values: any) {
    try {
        const files = values.files as File[] // Fix incorrect field name

        if (!files || files.length === 0) {
            return { error: "No files uploaded" }
        }

        const uploadDir = join(process.cwd(), `public/uploads/gallery`)
        await fs.mkdir(uploadDir, { recursive: true }) // Ensure directory exists

        const savedPaths = await Promise.all(
            files.map(async (file) => {
                const bytes = await file.arrayBuffer()
                const buffer = Buffer.from(bytes)
                const filePath = `${Date.now()}-${file.name}`
                await fs.writeFile(join(uploadDir, filePath), buffer)
                return `/uploads/gallery/${filePath}` // Store as relative path
            })
        )

        // Save to database
        const newGalleryItem = await prisma.gallery.create({
            data: {
                title: values.title,
                category: values.category,
                images: JSON.stringify(savedPaths), // Store as JSON string
            },
        })

        return { success: true, gallery: newGalleryItem }
    } catch (error) {
        console.error("File upload error:", error)
        return { error: "Failed to upload files" }
    }
}

export async function getGallery() {
    const gallery = await prisma.gallery.findMany({
        orderBy: {
            createdAt: "desc"
        }
    })
    gallery.forEach((item) => {
        item.images = JSON.parse(item.images) // Convert JSON string back to array
    })
    return { gallery }
}
