'use server'

import { prisma } from "@/lib/db"
import { promises as fs } from 'fs'
// Get Courses
export async function getCourses() {
    try {
        const courses = await prisma.courses.findMany({
            orderBy: { createdAt: 'desc' },
            include: { category: true }
        })
        return { courses }
    } catch (error) {
        return { error: "Unable to fetch Courses" }
    }
}

// Create Course
export async function createCourse(values: any) {
    try {
        let logourl = "";
        if (values.banner instanceof File) {
            let logoUrl = values.banner
            const img = await logoUrl.arrayBuffer();

            const imgdata = await fs.writeFile(`${process.cwd()}/public/upload/banner/${logoUrl.name}`, Buffer.from(img))
            logourl = `/upload/banner/${logoUrl.name}`// ✅ Upload file
        }
        const created = await prisma.courses.create({
            data: {
                name: values.name,
                description: values.description,
                price: Number.parseInt(values.price),
                duration: Number.parseInt(values.duration),
                level: values.level,
                categoryId: values.categoryId,
                banner: logourl
            }
        })
        const course = await prisma.courses.findUnique({
            where: { id: created.id },
            include: { category: true }
        })
        return { course }
    } catch (error) {
        return { error: "Unable to create course" }
    }
}

// Update Course
export async function updateCourse(id: string, values: any) {
    try {
        const find = await prisma.courses.findUnique({
            where: {
                id
            }
        })
        let logourl = "";
        if (values.banner instanceof File) {
            let logoUrl = values.banner
            const img = await logoUrl.arrayBuffer();

            const imgdata = await fs.writeFile(`${process.cwd()}/public/upload/banner/${logoUrl.name}`, Buffer.from(img))
            logourl = `/upload/banner/${logoUrl.name}`// ✅ Upload file
        } else {
            logourl = find?.banner as string
        }
        const updated = await prisma.courses.update({
            where: { id: find?.id },
            data: {
                name: values.name,
                description: values.description,
                price: Number.parseInt(values.price),
                duration: Number.parseInt(values.duration),
                level: values.level,
                categoryId: values.categoryId,
                banner: logourl
            }
        })
        const course = await prisma.courses.findUnique({
            where: { id: updated.id },
            include: { category: true }
        })
        return { course }
    } catch (error) {
        return { error: "Unable to update course" }
    }
}

// Delete Course
export async function deleteCourseById(id: string) {
    try {
        await prisma.courses.delete({ where: { id } })
        return { success: true }
    } catch (error) {
        return { error: "Unable to delete course" }
    }
}


export async function getCourseSections(id: string) {
    try {
        const courseSections = await prisma.section.findMany({
            where: {
                courseId: id
            },
            include: {
                lesson: true

            }
        })
        return { courseSections }
    } catch (error) {
        return { error: "Unable to delete course" }
    }
}

export async function getCourseById(id: string) {
    try {
        const course = await prisma.courses.findUnique({
            where: {
                id: id
            },
            include: {
                Section: {
                    select: {
                        id: true,
                        title: true,
                        lesson: true
                    }
                },

            }

        })
        return { course }

    } catch (error) {
        return { error: "Unable to fetch Course" }
    }

}