'use server'
import { prisma } from '@/lib/db';

import { promises as fs } from 'fs'
export async function createCompany(values: any) {
    let logourl = "";
    if (values.logo instanceof File) {
        let logoUrl = values.logo
        const img = await logoUrl.arrayBuffer();

        const imgdata = await fs.writeFile(`${process.cwd()}/public/upload/company/${logoUrl.name}`, Buffer.from(img))
        logourl = `/upload/company/${logoUrl.name}`// ✅ Upload file
    }
    try {
        const company = await prisma.company.create({
            data: {
                name: values.name,
                logo: logourl
            }
        })
        return { company }
    } catch (error) {
        return { error: "Unable to create Company" }
    }

}

export async function getAllCompany() {
    try {
        const companies = await prisma.company.findMany({
            orderBy: {
                createdAt: "desc"
            }
        })
        return { companies }

    } catch (error) {
        return { error: "Unable to fetch All Companies" }
    }
}

export async function deleteCompanyById(id: string) {
    try {
        
        const deleted = await prisma.company.delete({
            where: {
                id: id
            }
        })

        if (deleted) {
            return { success: "Company Deleted Successfully" }
        }
    } catch (error) {
        return { error: "Unable to Delete Company" }
    }
}