'use server'
import { prisma } from '@/lib/db';

import { promises as fs } from 'fs'
export async function createClient(values: any) {
    let logourl = "";
    if (values.logo instanceof File) {
        let logoUrl = values.logo
        const img = await logoUrl.arrayBuffer();

        const imgdata = await fs.writeFile(`${process.cwd()}/public/upload/clients/${logoUrl.name}`, Buffer.from(img))
        logourl = `/upload/clients/${logoUrl.name}`// ✅ Upload file
    }
    try {
        const client = await prisma.clients.create({
            data: {
                name: values.name,
                logo: logourl
            }
        })
        return { client }
    } catch (error) {
        return { error: "Unable to create client" }
    }

}

export async function getAllClients() {
    try {
        const companies = await prisma.clients.findMany({
            orderBy: {
                createdAt: "desc"
            }
        })
        return { companies }

    } catch (error) {
        return { error: "Unable to fetch All Companies" }
    }
}

export async function deleteClientById(id: string) {
    try {

        const deleted = await prisma.clients.delete({
            where: {
                id: id
            }
        })

        if (deleted) {
            return { success: "client Deleted Successfully" }
        }
    } catch (error) {
        return { error: "Unable to Delete client" }
    }
}