'use server'

import { prisma } from "@/lib/db"

export async function createCategory(values: any) {
    try {
        const created = await prisma.category.create({
            data: {
                ...values
            }
        });

        const category = await prisma.category.findUnique({
            where: { id: created.id },
            include: {
                _count: {
                    select: { courses: true }
                }
            }
        });

        return { category }; // Ensure it returns a single object
    } catch (error) {
        return { error: "Unable to Create Category" };
    }
}

export async function updateCategoryById(values: any, id: string) {
    try {
        const updated = await prisma.category.update({
            where: { id },
            data: { ...values }
        });

        const category = await prisma.category.findUnique({
            where: { id },
            include: {
                _count: {
                    select: { courses: true }
                }
            }
        });

        return { category }; // Ensure it returns a single object
    } catch (error) {
        return { error: "Unable to Update Category" };
    }
}

export async function deleteCategoryById(id: string) {
    try {
        const category = await prisma.category.delete({
            where: {
                id: id
            },

        })

        return { success: "Deleted Successfully" }
    } catch (error) {
        return { error: "Unable to Update Category" }
    }

}


export async function getAllCategories() {
    try {
        const categories = await prisma.category.findMany({
            orderBy: {
                createdAt: "desc"
            },
            include: {
                _count: {
                    select: {
                        courses: true
                    }
                }
            }
        })



        return { categories }
    } catch (error) {
        return { error: "Unable to fetch Categories" }
    }
}