"use server";

import { prisma } from "@/lib/db";
import { SessionData, defaultSession, sessionOptions } from "@/lib/lib";
import { getIronSession } from "iron-session";
import { cookies } from "next/headers";



export const getSession = async () => {
    // ✅ Convert read-only cookies to an object that can be modified
    const session = await getIronSession<SessionData>(await cookies(), sessionOptions);

    if (!session.islogged) {
        session.islogged = defaultSession.islogged;
    }

    return session;
};

export const login = async (values: any) => {
    const session = await getSession();
    try {
        const result = await prisma.user.findUnique({
            where: { email: values.email }
        });

        if (!result) {
            return { error: "No user found" };
        }

        if (result.password !== values.password) {
            return { error: "Password does not match" };
        }

        // ✅ Save session data
        session.id = result.id;
        session.name = result.name;
        session.email = result.email;
        session.islogged = true;
        session.role = result.role

        // ✅ Explicitly save the session
        await session.save();

        // ✅ Redirect after login


    } catch (error) {
        console.error("Login Error:", error);
        return { error: "Unable to fetch user" };
    }
};

// ✅ Logout Function
export const logout = async () => {
    const session = await getSession();
    session.destroy(); // Clears session
    // Redirect to login page
};

export const register = async (values: any) => {
    try {
        const result = await prisma.user.findUnique({
            where: { email: values.email }
        });

        if (result) {
            return { error: "Email Already Exists" }
        }

        await prisma.user.create({
            data: {
                ...values
            }

        })
    } catch (error) {
        return { error: " Server Error" }
    }
}
