'use server'
import { prisma } from '@/lib/db';

import { promises as fs } from 'fs'
export async function createPartner(values: any) {
    let logourl = "";
    if (values.logo instanceof File) {
        let logoUrl = values.logo
        const img = await logoUrl.arrayBuffer();

        const imgdata = await fs.writeFile(`${process.cwd()}/public/upload/clients/${logoUrl.name}`, Buffer.from(img))
        logourl = `/upload/clients/${logoUrl.name}`// ✅ Upload file
    }
    try {
        const company = await prisma.partner.create({
            data: {
                name: values.name,
                logo: logourl,
                website:values.website
            }
        })
        return { company }
    } catch (error) {
        return { error: "Unable to create Company" }
    }

}

export async function getAllCompany() {
    try {
        const companies = await prisma.company.findMany({
            orderBy: {
                createdAt: "desc"
            }
        })
        return { companies }

    } catch (error) {
        return { error: "Unable to fetch All Companies" }
    }
}

export async function deleteCompanyById(id: string) {
    try {

        const deleted = await prisma.company.delete({
            where: {
                id: id
            }
        })

        if (deleted) {
            return { success: "Company Deleted Successfully" }
        }
    } catch (error) {
        return { error: "Unable to Delete Company" }
    }
}