'use client'
import { getAllTestimonials } from '@/app/api/testimonials'
import { createColumns, testimonials } from '@/components/admin/testimonials/columns'
import TestimonialModel from '@/components/admin/testimonials/testimonials-dialog'



import { Button } from '@/components/ui/button'
import { Card, CardContent, CardHeader } from '@/components/ui/card'
import { DataTable } from '@/components/ui/data-table'
import React, { useEffect, useState } from 'react'

const Testimonial = () => {
    const [open, setOpen] = useState(false)
    const [selectedTestimonial, setSelectedTestimonial] = useState<testimonials | null>(null);
    const [testimonials, setTestimonials] = useState<any[]>([]);
    const [loading, setLoading] = useState(true);
    const [error, setError] = useState("");

    useEffect(() => {
        const fetchCompanies = async () => {
            const { testimonials, error } = await getAllTestimonials()
            if (error) {
                setError(error)
            } else {
                setTestimonials(testimonials as [])
                setLoading(false)
            }


        }
        fetchCompanies();
    }, [])

    // Handle Edit - Open Dialog with selected testimonial
    const handleEdit = (testimonial: testimonials) => {
        setSelectedTestimonial(testimonial);
        setOpen(true);
    };

    // Handle Delete - Open Delete Confirmation Dialog
    const handleDelete = (id: string) => {
        setSelectedTestimonial(testimonials.find(t => t.id === id) || null);
        setOpen(true);
    };

    // Pass functions to columns
    const columns = createColumns(handleEdit, handleDelete);

    return (
        <div className=' space-y-6'>
            <div className='flex items-center justify-between'>
                <h1 className='text-2xl font-bold'>Testimonials</h1>
                <Button onClick={() => setOpen(true)}>
                    Add New Testimonial
                </Button>
            </div>
            <TestimonialModel open={open} onOpenChange={setOpen} changeState={setTestimonials} />

            <Card>
                <CardHeader>
                    All Testimonials
                </CardHeader>
                <CardContent>
                    <DataTable columns={columns} data={testimonials} />
                </CardContent>
            </Card>


        </div>
    )
}

export default Testimonial