import React from 'react'

import { Button } from '@/components/ui/button'
import Link from 'next/link'
import StatCard from '@/components/ui/statscard'
import { Users, BookOpen, GraduationCap, DollarSign, ArrowRight } from 'lucide-react'
import { Card, CardHeader, CardTitle, CardContent } from '@/components/ui/card'


const AdminPage = async () => {

    return (
        <div className='space-y-6'>
            <div className='flex items-center justify-between'>
                <h1 className="text-3xl font-bold">Dashboard</h1>
                <Button asChild>
                    <Link href="/admin/courses/new">Create Course</Link>
                </Button>
            </div>
            <div className="grid gap-6 md:grid-cols-2 lg:grid-cols-4">
                <StatCard title="Total Students" value="12,345" icon={Users} trend={{ value: 12, isPositive: true }} />
                <StatCard title="Active Courses" value="48" icon={BookOpen} trend={{ value: 8, isPositive: true }} />
                <StatCard title="Total Instructors" value="156" icon={GraduationCap} trend={{ value: 5, isPositive: true }} />
                <StatCard title="Total Revenue" value="$48,256" icon={DollarSign} trend={{ value: 15, isPositive: true }} />
            </div>
            <div className="grid gap-6 md:grid-cols-2">
                <Card>
                    <CardHeader className="flex flex-row items-center justify-between">
                        <CardTitle>Revenue Overview</CardTitle>
                        <Button variant="ghost" size="sm">
                            View Report
                            <ArrowRight className="ml-2 h-4 w-4" />
                        </Button>
                    </CardHeader>
                    <CardContent>
                        <div className="h-[300px] flex items-center justify-center text-muted-foreground">Revenue Chart</div>
                    </CardContent>
                </Card>

                <Card>
                    <CardHeader className="flex flex-row items-center justify-between">
                        <CardTitle>Student Enrollment</CardTitle>
                        <Button variant="ghost" size="sm">
                            View Report
                            <ArrowRight className="ml-2 h-4 w-4" />
                        </Button>
                    </CardHeader>
                    <CardContent>
                        <div className="h-[300px] flex items-center justify-center text-muted-foreground">Enrollment Chart</div>
                    </CardContent>
                </Card>
            </div>
        </div >
    )
}

export default AdminPage