import React, { ReactNode } from 'react'
import { getSession } from '../api/actions';
import { redirect } from 'next/navigation';
import AdminSidebar from '@/components/header/adminSidebar';
import { Button } from '@/components/ui/button';
import { Input } from '@/components/ui/input';
import { DropdownMenu, DropdownMenuTrigger, DropdownMenuContent, DropdownMenuLabel, DropdownMenuSeparator, DropdownMenuItem } from '@radix-ui/react-dropdown-menu';
import { Search, Bell, ChevronDown } from 'lucide-react';
import Image from "next/image"
interface AdminLayoutProps {
    children: ReactNode;
}

const Adminlayout = async ({ children }: AdminLayoutProps) => {
    const session = await getSession();
    if (!session.islogged && session.role !== "admin") {
        return redirect("/login")
    }
    return (
        <div className="min-h-screen bg-gray-100">
            <div className="flex">
                <AdminSidebar />
                <div className="flex-1">
                    <header className="bg-white border-b h-16 flex items-center justify-between px-6">
                        <div className="flex items-center flex-1 space-x-4">
                            <div className="w-72">
                                <div className="relative">
                                    <Search className="absolute left-2.5 top-2.5 h-4 w-4 text-muted-foreground" />
                                    <Input type="search" placeholder="Search..." className="pl-8 bg-gray-50" />
                                </div>
                            </div>
                        </div>
                        <div className="flex items-center space-x-4">
                            <Button variant="ghost" size="icon">
                                <Bell className="h-5 w-5" />
                            </Button>
                            <DropdownMenu>
                                <DropdownMenuTrigger asChild>
                                    <Button variant="ghost" className="flex items-center space-x-2">
                                        <Image src={`https://ui-avatars.com/api/?name="Admin"`} alt="Admin" width={24} height={24} className="rounded-full" />
                                        <span>Admin User</span>
                                        <ChevronDown className="h-4 w-4" />
                                    </Button>
                                </DropdownMenuTrigger>
                                <DropdownMenuContent align="end" className="w-56">
                                    <DropdownMenuLabel>My Account</DropdownMenuLabel>
                                    <DropdownMenuSeparator />
                                    <DropdownMenuItem>Profile</DropdownMenuItem>
                                    <DropdownMenuItem>Settings</DropdownMenuItem>
                                    <DropdownMenuSeparator />
                                    <DropdownMenuItem>Log out</DropdownMenuItem>
                                </DropdownMenuContent>
                            </DropdownMenu>
                        </div>
                    </header>
                    <main className="p-6">{children}</main>
                </div>
            </div>
        </div>
    )
}

export default Adminlayout