'use client'
import { getAllCategories } from '@/app/api/categories';
import { getCourses } from '@/app/api/courses';
import { createColumns } from '@/components/admin/course/columns';
import CourseModel from '@/components/admin/course/course-dialog';

import { Button } from '@/components/ui/button'
import { Card, CardContent, CardHeader } from '@/components/ui/card';
import { DataTable } from '@/components/ui/data-table';
import React, { useEffect, useState } from 'react'

export type Course = {
    id: string;
    name: string;
    description: string;
    price: number;
    duration: number;
    level: string;
    category: {
        id: string;
        name: string;
    };
    createdAt: string;
    updatedAt: string;
}

export type DialogState = {
    open: boolean,
    action: "add" | "edit" | "delete" | null,
    course: Course | null
}
const Courses = () => {
    const [dialogState, setDialogState] = useState<DialogState>({
        open: false,
        action: null,
        course: null,
    });
    const [courses, SetCourses] = useState<any[]>([])
    const [categories, SetCategories] = useState<any[]>([])
    useEffect(() => {
        const fetchCourses = async () => {
            try {
                const { courses } = await getCourses();
                SetCourses(courses || []);
            } catch (error) {
                console.log("Error fetching courses:", error);
            }
        };

        const fetchCategories = async () => {
            try {
                const { categories } = await getAllCategories();
                SetCategories(categories || []);
            } catch (error) {
                console.log("Error fetching categories:", error);
            }
        };

        fetchCourses();
        fetchCategories();
    }, [])
    const openAddDialog = () => {
        setDialogState({ open: true, action: "add", course: null });
    };

    const openEditDialog = (course: Course) => {
        setDialogState({ open: true, action: "edit", course: course });
    };

    const openDeleteDialog = (course: Course) => {
        setDialogState({ open: true, action: "delete", course: course });
    };

    const closeDialog = () => {
        setDialogState({ open: false, action: null, course: null });
    };
    const columns = createColumns(openEditDialog, openDeleteDialog);
    return (
        <div className=' space-y-6'>
            <div className='flex items-center justify-between'>
                <h1 className='text-2xl font-bold'>Courses</h1>
                <Button onClick={openAddDialog}>
                    Add New Course
                </Button>
            </div>
            <CourseModel state={dialogState} onOpenChange={closeDialog} updateState={SetCourses} categories={categories.map((category) => ({
                id: category.id,
                value: category.name,
            }))} />
            <Card>
                <CardHeader>
                    All Testimonials
                </CardHeader>
                <CardContent>
                    <DataTable columns={columns} data={courses} />
                </CardContent>
            </Card>
        </div>
    )
}

export default Courses