'use client'
import { deleteClientById, getAllClients } from '@/app/api/clients'
import ClientModel from '@/components/admin/client/client-model'
import { Button } from '@/components/ui/button'
import { Card, CardContent, CardFooter } from '@/components/ui/card'
import { Loader2Icon } from 'lucide-react'
import Image from 'next/image'
import { useRouter } from 'next/navigation'
import React, { useEffect, useState } from 'react'

const ClientPage = () => {
    const router = useRouter()
    const [open, setOpen] = useState(false)
    const [companies, setCompanies] = useState<any[]>([]);
    const [loading, setLoading] = useState(true);
    const [error, setError] = useState("");

    useEffect(() => {
        const fetchCompanies = async () => {
            const { companies, error } = await getAllClients()
            if (error) {
                setError(error)
            } else {
                setCompanies(companies as [])
                setLoading(false)
            }


        }
        fetchCompanies();
    }, [])

    const deleteClient = async (id: string) => {
        await deleteClientById(id).then((value) => {
            if (value?.error) {
                console.log(value.error)
            } else {
                console.log(value?.success)
                window.location.reload()
            }
        })
    }

    if (loading) return <div className=' w-full min-h-screen flex items-center justify-center'> <Loader2Icon />s</div>
    if (error) return <p>Error: {error}</p>;
    return (
        <div className=' space-y-6'>
            <div className='flex items-center justify-between'>
                <h1 className='text-2xl font-bold'>Companies</h1>
                <Button onClick={() => setOpen(true)}>
                    Add New Client
                </Button>
            </div>

            <ClientModel open={open} onOpenChange={setOpen} />

            <div className='grid grid-cols-1 md:grid-cols-3 gap-5'>
                {companies.map((Client) => (
                    <Card key={Client.id}>
                        <CardContent>
                            <div className='flex items-center justify-center'>
                                <Image src={Client.logo} alt={Client.name} width={100} height={100} className='w-full h-36' priority />
                            </div>
                            <div className=' flex items-center justify-end gap-4 mt-4'>
                                <Button onClick={() => {
                                    deleteClient(Client.id)
                                    router.refresh()
                                }} variant="destructive">Delete</Button>
                            </div>
                        </CardContent>

                    </Card>
                ))}
            </div>

        </div>
    )
}

export default ClientPage