'use client'

import { getAllCategories } from '@/app/api/categories'
import CategoryModel from '@/components/categories/category-dialog'
import { createColumns } from '@/components/categories/columns'
import { Button } from '@/components/ui/button'
import { Card, CardContent, CardHeader, CardTitle } from '@/components/ui/card'
import { DataTable } from '@/components/ui/data-table'
import { Loader, LoaderCircle } from 'lucide-react'
import React, { useEffect, useState } from 'react'

export type category = {
    id: string
    name: string
    icon:string
    _count: any
}
export type DialogState = {
    open: boolean;
    action: "add" | "edit" | "delete" | null;
    selectCategory: category | null;
};

const Categories = () => {
    const [dialogState, setDialogState] = useState<DialogState>({
        open: false,
        action: null,
        selectCategory: null,
    });

    const [categories, setCategories] = useState<category[]>([]);

    const [loading, setLoading] = useState<boolean>(true);
    const [error, setError] = useState<string>("");

    useEffect(() => {
        const fetchAllCategory = async () => {
            const { categories, error } = await getAllCategories();
            if (error) {
                setError(error)
            } else {
                setCategories(categories as [])
                setLoading(false)
            }
        }
        fetchAllCategory()
    }
        , [])

    const openAddDialog = () => {
        setDialogState({ open: true, action: "add", selectCategory: null });
    };

    const openEditDialog = (category: category) => {
        setDialogState({ open: true, action: "edit", selectCategory: category });
    };

    const openDeleteDialog = (category: category) => {
        setDialogState({ open: true, action: "delete", selectCategory: category });
    };

    const closeDialog = () => {
        setDialogState({ open: false, action: null, selectCategory: null });
    };

    const columns = createColumns(openEditDialog, openDeleteDialog);

    return (
        <div className=' space-y-6'>
            <div className='flex items-center justify-between'>
                <h1 className='text-2xl font-bold'>Categories</h1>
                <Button onClick={openAddDialog}>
                    Add New Category
                </Button>
            </div>

            <CategoryModel state={dialogState} onOpenChange={closeDialog} updateCategory={setCategories} />

            <Card>
                <CardHeader>
                    <CardTitle>All Categories</CardTitle>
                </CardHeader>
                <CardContent>
                    {loading ? (<div className='w-full h-full flex items-center justify-center'>
                        <Loader className='animate-spin' />
                    </div>) :
                        <DataTable columns={columns} data={categories} />
                    }

                </CardContent>
            </Card>
        </div>
    )
}

export default Categories