'use client'
import HeroSection from '@/components/hero-section'
import { Image } from 'lucide-react'
import React, { useEffect, useState } from 'react'
import { getGallery } from '@/app/api/gallery'

const Page = () => {
  const [gallery, setGallery] = useState<any[]>([])
  const [loading, setLoading] = useState(true)

  useEffect(() => {
    const fetchGallery = async () => {
      const { gallery } = await getGallery()
      setGallery(gallery || [])
      setLoading(false)
    }
    fetchGallery()
  }, [])

  return (
    <div>
      <HeroSection title='Our Courses' link='courses' />

      <div className='container mx-auto py-16'>
        {/* Heading Section */}
        <div className="py-16 max-w-xl md:max-w-2xl mx-auto flex flex-col items-center gap-4">
          <h1 className="flex items-center gap-3 text-[#066ccc] text-2xl font-bold">
            <Image /> Gallery
          </h1>
          <h2 className="text-4xl md:text-5xl font-bold text-center">
            Captured Moments, Endless Inspiration
          </h2>
          <p className="text-center text-md md:text-lg text-gray-600">
            Relive the experiences that shape our students into future tech leaders.
          </p>
        </div>

        {/* Gallery Grid Section */}
        {loading ? (
          <div className="text-center text-xl">Loading...</div>
        ) : (
          <div className='grid grid-cols-1 md:grid-cols-3 gap-6'>
            {gallery.map((item) =>
              item.images.map((image: string, index: number) => (
                <img key={index} src={image} alt="Gallery Image" className='rounded-lg w-full h-60 object-cover' />
              ))
            )}
          </div>
        )}
      </div>
    </div>
  )
}

export default Page
