'use client'
import { getCourses } from '@/app/api/courses';
import CallToAction from '@/components/CTA';
import HeroSection from '@/components/hero-section';
import WhyChooseUs from '@/components/public/whychooseus';
import { Badge } from '@/components/ui/badge';
import { Button } from '@/components/ui/button';
import { Card, CardContent, CardFooter, CardHeader, CardTitle } from '@/components/ui/card';
import { ArrowRight, BadgeIndianRupee, ChartNoAxesCombined, Clock, Clock3, IndianRupee, IndianRupeeIcon, Loader, Star, Users, Video } from 'lucide-react';
import Image from 'next/image';
import Link from 'next/link';
import React, { useEffect, useState } from 'react'

const Courses = () => {
    const [courses, setCourses] = useState<any[]>([]);
    const [loading, setLoading] = useState(true);
    console.log(courses)
    useEffect(() => {
        const fetchCourses = async () => {
            const { courses, error } = await getCourses()
            if (!error) {
                setCourses(courses || [])
            }
        }
        fetchCourses()
        setLoading(false)
    }, [])

    return (
        <div>
            <HeroSection title='Our Courses' link='courses' />
            <div className='container mx-auto py-16'>
                <div className=' space-y-6 text-center max-w-3xl mx-auto mb-5 py-5'>
                    <h1 className='text-3xl font-bold tracking-tight sm:text-5xl mb-6'>
                        Why Choose Our Courses?
                    </h1>
                    <p className='text-lg text-gray-500 max-w-3xl mx-auto mb-12'>
                        Master in-demand skills with expert-led training, real-world projects, and dedicated support to accelerate your tech career.
                    </p>
                </div>
                <div className='grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-4 p-5'>

                    {
                        loading ?
                            <div className='w-full h-full flex items-center justify-center'><Loader className="h-8 w-8 animate-spin" /> Loading...</div>
                            :
                            courses.map((course) => (
                                <Link href={`/courses/${course.id}`} key={course.id}>

                                    <Card>
                                        <CardContent className='relative'>
                                            <img src={course.banner} alt="Coures Name" className='w-full h-[300px] rounded-xl' />
                                            <div className='mt-5'>
                                                <h1 className='text-3xl font-bold'>{course.name}</h1>
                                                <div className='flex items-center justify-between mt-5 mb-6'>
                                                    <div className='flex items-center gap-2  text-lg text-gray-700'><Video /> 20 Lessons</div>
                                                    <div className='flex items-center gap-2 text-lg text-gray-700'><ChartNoAxesCombined /> {course.level}</div>
                                                </div>
                                                <div className='flex items-center justify-between mb-6'>
                                                    <div className='flex items-center gap-2 text-lg text-gray-700'><Star className='text-orange-600 ' /> 4.7 (6K)</div>

                                                </div>
                                                <hr />
                                                <div className='flex items-center justify-between mt-5 mb-6'>
                                                    <div className='flex items-center   text-2xl font-bold text-orange-500'><IndianRupee className='w-6 h-6' /> {course.price}</div>
                                                    <div className='flex items-center gap-2 text-lg text-gray-700'> Enroll Now <ArrowRight /> </div>
                                                </div>
                                            </div>
                                            <div className='w-36 h-12 bg-[#066ccc] rounded-full absolute top-5 left-10 p-2'>
                                                <div className='flex items-center justify-center gap-2 text-lg text-white'><Clock3 /> {course.duration} Months</div>
                                            </div>

                                        </CardContent>
                                    </Card>
                                </Link>
                            ))}


                </div>
            </div>
            <WhyChooseUs />
            <CallToAction />
        </div>
    )
}

export default Courses