import HeroSection from '@/components/hero-section'
import ContactSection from '@/components/public/contctForm'
import { Card, CardContent, CardHeader } from '@/components/ui/card'
import { Clock2, Globe2, MailCheck, PhoneCall } from 'lucide-react'
import React from 'react'

const contactDetail = [
    {
        icon: <Globe2 className='h-10 w-10' />,
        title: "Our Address",
        content: "722/17 Nai Basti, Gurgaon, Haryana - 122001",

    },
    {
        icon: <PhoneCall className='h-10 w-10' />,
        title: "Contact Number",
        content: "+91-8398948765",

    },
    {
        icon: <MailCheck className='h-10 w-10' />,
        title: "Email Address",
        content: "inquiry@binaryqubit.com",

    },
    {
        icon: <Clock2 className='h-10 w-10' />,
        title: "Class Schedule",
        content: "10:00 AM - 9:00 PM",

    }
]
const ContactUs = () => {
    return (
        <div>
            <HeroSection title='Contact Us' link='contact-us' />
            <div className='py-16'>
                <div className='container mx-auto'>
                    <div className='grid grid-cols-1 md:grid-cols-4 gap-5'>
                        {contactDetail.map((detail, i) => (
                            <Card key={i} className="bg-gray-900 text-white">
                                <CardHeader>
                                    {detail.icon}
                                </CardHeader>
                                <CardContent className='space-y-4'>
                                    <h3 className='text-2xl font-bold'>{detail.title}</h3>
                                    <hr />
                                    <p>{detail.content}</p>
                                </CardContent>
                            </Card>
                        ))}
                    </div>
                </div>
            </div>
            <ContactSection />
        </div>
    )
}

export default ContactUs