'use client'
import { getAllCompany } from '@/app/api/Partners';
import { getAllClients } from '@/app/api/clients';
import CallToAction from '@/components/CTA';

import HeroSection from '@/components/hero-section';


import { Card, CardContent } from '@/components/ui/card';
import { Building } from 'lucide-react';

import React, { useEffect, useState } from 'react'
import Carousel from "react-multi-carousel";


const Clients = () => {
    const [clients, setClients] = useState<any[]>([]);
    const [partners, setPartners] = useState<any[]>([]);
    useEffect(() => {
        const fetchCourses = async () => {
            const { companies, error } = await getAllClients()
            if (!error) {
                setClients(companies || [])
            }
        }
        const fetchPartners = async () => {
            const { companies, error } = await getAllCompany()
            if (!error) {
                setPartners(companies || [])
            }
        }

        fetchCourses()
        fetchPartners()
    }, [])
    const responsive = {
        superLargeDesktop: {
            // the naming can be any, depends on you.
            breakpoint: { max: 4000, min: 3000 },
            items: 4
        },
        desktop: {
            breakpoint: { max: 3000, min: 1024 },
            items: 3
        },
        tablet: {
            breakpoint: { max: 1024, min: 464 },
            items: 2
        },
        mobile: {
            breakpoint: { max: 464, min: 0 },
            items: 1
        }
    };
    return (
        <div>
            <HeroSection title='Our Collabrations' link='clients' />
            <div className='container mx-auto py-16'>
                <div className="py-16 max-w-xl md:max-w-2xl mx-auto flex flex-col items-center gap-4">
                    <h1 className="flex items-center justify-center gap-3 text-[#066ccc] text-2xl font-bold">
                        <Building /> Clients
                    </h1>
                    <h2 className="text-4xl md:text-5xl font-bold text-center">
                        Empowering Your Success, One Solution at a Time
                    </h2>
                    <p className="text-center  text-md md:text-lg text-gray-600">
                        Tailored Services to Elevate Your Business and Experiences
                    </p>
                </div>

                <Carousel responsive={responsive}>
                    {clients.map((client) => (
                        <Card key={client.id} className='mr-5' >
                            <CardContent >
                                {client.logo ? (
                                    <img
                                        src={client.logo}
                                        alt={client.name}
                                        className="h-48 w-full rounded object-fill"
                                    />
                                ) : (
                                    <div className="h-48 w-full  rounded bg-primary/10 flex items-center justify-center">
                                        <span className="text-lg font-semibold text-primary">{client.name}</span>
                                    </div>
                                )}


                                <div className="text-center px-6 mt-4">
                                    {client.name}
                                </div>


                            </CardContent>


                        </Card>

                    ))}

                    {!clients && (<><p>NO Clients Available</p></>)}



                </Carousel>;
            </div>
            <div className='bg-[#f2f9ff] py-16'>
                <div className='container mx-auto '>
                    <div className="py-16 max-w-xl md:max-w-2xl mx-auto flex flex-col items-center gap-4">
                        <h1 className="flex items-center justify-center gap-3 text-[#066ccc] text-2xl font-bold">
                            <Building /> Our Partners
                        </h1>
                        <h2 className="text-4xl md:text-5xl font-bold text-center">
                            Building Stronger Partnerships, Creating Lasting Value
                        </h2>
                        <p className="text-center  text-md md:text-lg text-gray-600">
                            Innovative Solutions for Your Unique Needs
                        </p>
                    </div>
                    <Carousel responsive={responsive}>
                        {partners.map((partner) => (
                            <Card key={partner.id} className="mr-5">
                                <CardContent >
                                    {partner.logo ? (
                                        <img
                                            src={partner.logo}
                                            alt={partner.name}
                                            className="h-48 w-full rounded object-fill"
                                        />
                                    ) : (
                                        <div className="h-48 w-full  rounded bg-primary/10 flex items-center justify-center">
                                            <span className="text-lg font-semibold text-primary">{partner.name}</span>
                                        </div>
                                    )}


                                    <div className="text-center px-6 mt-4">
                                        {partner.name}
                                    </div>


                                </CardContent>


                            </Card>

                        ))}

                        {!clients && (<><p>NO Clients Available</p></>)}



                    </Carousel>
                </div>
            </div>

            <CallToAction />

        </div>
    )
}

export default Clients