import HeroSection from '@/components/hero-section'

import React from 'react'
import Image from 'next/image'
import { Card, CardContent } from '@/components/ui/card'
import banner from '@/public/aboutus.jpg'
import CallToAction from '@/components/CTA'



const AboutUs = () => {
    return (
        <div>
            <HeroSection title="About Us" link='about-us' />

            <div className="container mx-auto py-16 px-6">

                <div className="grid grid-cols-1 md:grid-cols-2 gap-8 mt-12">
                    <div>
                        <h1 className="text-4xl font-bold text-gray-900 mb-4">About BinaryQubit</h1>
                        <p className="text-lg text-gray-600">


                            At BinaryQubit, we are committed to empowering learners with
                            cutting-edge skills in AI, Web Development, Machine Learning,
                            and Data Science. Our mission is to bridge the gap between theoretical
                            knowledge and real-world application by offering high-quality, industry-relevant
                            coding courses.
                        </p>
                        <p>At BinaryQubit, we are dedicated to empowering aspiring developers and data
                            enthusiasts with industry-relevant skills in AI, Web Development, Machine
                            Learning, and Data Science. Our structured courses, ranging from fundamental
                            programming to advanced roadmap-based training, equip learners with the
                            knowledge and hands-on experience needed to excel in the tech industry.</p>

                        <h2 className="text-2xl font-bold text-gray-900 mb-4"> Who We Are</h2>
                        <p>BinaryQubit is a premier coding education platform
                            that provides structured learning paths for beginners and professionals
                            alike. Whether you're starting your journey with basic programming
                            languages or diving into advanced topics like AI-powered businesses,
                            Data Analytics, and Algorithmic Trading, we offer a comprehensive
                            learning experience tailored to industry demands.
                        </p>

                        <h2 className="text-2xl font-bold text-gray-900 mb-4">What We Offer</h2>
                        <p>
                            Founded by Avinash Sood, an expert in AI-driven web development and data analytics,
                            BinaryQubit focuses on bridging the gap between academic
                            learning and real-world application. We specialize in:
                        </p>
                        <ul className="px-10">
                            <li>✅  Roadmap Courses: Master Full-Stack Web Development, Data Science, and AI through our structured learning paths.</li>
                            <li>✅  Hands-on Projects: Apply your knowledge through real-world projects in Flask, Next.js, TensorFlow, NLP, and more.</li>
                            <li>✅  Expert Guidance: Learn from industry professionals with expertise in AI, ML, and software development.</li>
                            <li>✅  Community & Support: Join a vibrant community of learners and get personalized mentorship to accelerate your growth.</li>
                            <li> ✅ Comprehensive Coding Courses – Covering Python, JavaScript, SQL, and more.</li>
                            <li>✅ AI & Data Science Training – Master machine learning, deep learning, and big data technologies.</li>
                            <li>✅ Web Development Bootcamps – Full-stack development with cutting-edge frameworks.</li>
                            <li>✅ Algorithmic Trading & NLP – Specialized courses for data-driven decision-making.</li>
                        </ul>

                        <p>
                            With an emphasis on practical projects, mentorship, and career growth, BinaryQubit ensures that learners not only acquire theoretical knowledge but also build real-world applications that enhance their portfolios.
                        </p>
                        <p>Join us on a journey of innovation and learning as we shape the future of technology together!</p>

                    </div>
                    <div>
                        <Image src={banner} alt="Binary Qubit - About us " className="rounded-2xl" priority />
                    </div>
                </div>




                {/* Mission & Vision Section */}
                <div className="grid grid-cols-1 md:grid-cols-2 gap-8 mt-12">
                    <Card className="shadow-md">
                        <CardContent className="p-6">
                            <h2 className="text-2xl font-semibold text-blue-600">Our Mission</h2>
                            <p className="text-gray-600 mt-3">
                                To equip learners with **AI-powered skills** that drive innovation,
                                making them job-ready in the fast-evolving tech industry.
                            </p>
                        </CardContent>
                    </Card>

                    <Card className="shadow-md">
                        <CardContent className="p-6">
                            <h2 className="text-2xl font-semibold text-purple-600">Our Vision</h2>
                            <p className="text-gray-600 mt-3">
                                We believe in democratizing tech education by making high-quality learning resources accessible to all. Our goal is to help individuals build real-world skills, advance their careers, and stay ahead in the ever-evolving tech landscape
                            </p>
                        </CardContent>
                    </Card>
                </div>


            </div>
            <CallToAction />
        </div>
    )
}

export default AboutUs