(globalThis.TURBOPACK = globalThis.TURBOPACK || []).push(["static/chunks/node_modules_@ckeditor_f76ffa85._.js", {

"[project]/node_modules/@ckeditor/ckeditor5-integrations-common/dist/index.js [app-client] (ecmascript)": ((__turbopack_context__) => {
"use strict";

var { g: global, __dirname } = __turbopack_context__;
{
/**
 * @license Copyright (c) 2003-2025, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-licensing-options
 */ __turbopack_context__.s({
    "CKBOX_CDN_URL": (()=>CKBOX_CDN_URL),
    "CK_CDN_URL": (()=>CK_CDN_URL),
    "INJECTED_SCRIPTS": (()=>INJECTED_SCRIPTS),
    "INJECTED_STYLESHEETS": (()=>INJECTED_STYLESHEETS),
    "appendExtraPluginsToEditorConfig": (()=>appendExtraPluginsToEditorConfig),
    "createCKBoxCdnUrl": (()=>createCKBoxCdnUrl),
    "createCKCdnUrl": (()=>createCKCdnUrl),
    "createDefer": (()=>createDefer),
    "createIntegrationUsageDataPlugin": (()=>createIntegrationUsageDataPlugin),
    "filterBlankObjectValues": (()=>filterBlankObjectValues),
    "filterObjectValues": (()=>filterObjectValues),
    "injectScript": (()=>injectScript),
    "injectScriptsInParallel": (()=>injectScriptsInParallel),
    "injectStylesheet": (()=>injectStylesheet),
    "isCKEditorFreeLicense": (()=>isCKEditorFreeLicense),
    "isSSR": (()=>isSSR),
    "loadCKEditorCloud": (()=>loadCKEditorCloud),
    "mapObjectValues": (()=>mapObjectValues),
    "once": (()=>once),
    "overwriteArray": (()=>overwriteArray),
    "overwriteObject": (()=>overwriteObject),
    "preloadResource": (()=>preloadResource),
    "shallowCompareArrays": (()=>shallowCompareArrays),
    "uid": (()=>uid),
    "uniq": (()=>uniq),
    "waitFor": (()=>waitFor),
    "waitForWindowEntry": (()=>waitForWindowEntry),
    "without": (()=>without)
});
function createDefer() {
    const deferred = {
        resolve: null,
        promise: null
    };
    deferred.promise = new Promise((resolve)=>{
        deferred.resolve = resolve;
    });
    return deferred;
}
/**
 * @license Copyright (c) 2003-2025, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-licensing-options
 */ function waitFor(callback, { timeOutAfter = 500, retryAfter = 100 } = {}) {
    return new Promise((resolve, reject)=>{
        const startTime = Date.now();
        let lastError = null;
        const timeoutTimerId = setTimeout(()=>{
            reject(lastError ?? new Error("Timeout"));
        }, timeOutAfter);
        const tick = async ()=>{
            try {
                const result = await callback();
                clearTimeout(timeoutTimerId);
                resolve(result);
            } catch (err) {
                lastError = err;
                if (Date.now() - startTime > timeOutAfter) {
                    reject(err);
                } else {
                    setTimeout(tick, retryAfter);
                }
            }
        };
        tick();
    });
}
/**
 * @license Copyright (c) 2003-2025, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-licensing-options
 */ const INJECTED_SCRIPTS = /* @__PURE__ */ new Map();
function injectScript(src, { attributes } = {}) {
    if (INJECTED_SCRIPTS.has(src)) {
        return INJECTED_SCRIPTS.get(src);
    }
    const maybePrevScript = document.querySelector(`script[src="${src}"]`);
    if (maybePrevScript) {
        console.warn(`Script with "${src}" src is already present in DOM!`);
        maybePrevScript.remove();
    }
    const promise = new Promise((resolve, reject)=>{
        const script = document.createElement("script");
        script.onerror = reject;
        script.onload = ()=>{
            resolve();
        };
        for (const [key, value] of Object.entries(attributes || {})){
            script.setAttribute(key, value);
        }
        script.setAttribute("data-injected-by", "ckeditor-integration");
        script.type = "text/javascript";
        script.async = true;
        script.src = src;
        document.head.appendChild(script);
        const observer = new MutationObserver((mutations)=>{
            const removedNodes = mutations.flatMap((mutation)=>Array.from(mutation.removedNodes));
            if (removedNodes.includes(script)) {
                INJECTED_SCRIPTS.delete(src);
                observer.disconnect();
            }
        });
        observer.observe(document.head, {
            childList: true,
            subtree: true
        });
    });
    INJECTED_SCRIPTS.set(src, promise);
    return promise;
}
async function injectScriptsInParallel(sources, props) {
    await Promise.all(sources.map((src)=>injectScript(src, props)));
}
/**
 * @license Copyright (c) 2003-2025, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-licensing-options
 */ const INJECTED_STYLESHEETS = /* @__PURE__ */ new Map();
function injectStylesheet({ href, placementInHead = "start", attributes = {} }) {
    if (INJECTED_STYLESHEETS.has(href)) {
        return INJECTED_STYLESHEETS.get(href);
    }
    const maybePrevStylesheet = document.querySelector(`link[href="${href}"][rel="stylesheet"]`);
    if (maybePrevStylesheet) {
        console.warn(`Stylesheet with "${href}" href is already present in DOM!`);
        maybePrevStylesheet.remove();
    }
    const appendLinkTagToHead = (link)=>{
        const previouslyInjectedLinks = Array.from(document.head.querySelectorAll('link[data-injected-by="ckeditor-integration"]'));
        switch(placementInHead){
            case "start":
                if (previouslyInjectedLinks.length) {
                    previouslyInjectedLinks.slice(-1)[0].after(link);
                } else {
                    document.head.insertBefore(link, document.head.firstChild);
                }
                break;
            case "end":
                document.head.appendChild(link);
                break;
        }
    };
    const promise = new Promise((resolve, reject)=>{
        const link = document.createElement("link");
        for (const [key, value] of Object.entries(attributes || {})){
            link.setAttribute(key, value);
        }
        link.setAttribute("data-injected-by", "ckeditor-integration");
        link.rel = "stylesheet";
        link.href = href;
        link.onerror = reject;
        link.onload = ()=>{
            resolve();
        };
        appendLinkTagToHead(link);
        const observer = new MutationObserver((mutations)=>{
            const removedNodes = mutations.flatMap((mutation)=>Array.from(mutation.removedNodes));
            if (removedNodes.includes(link)) {
                INJECTED_STYLESHEETS.delete(href);
                observer.disconnect();
            }
        });
        observer.observe(document.head, {
            childList: true,
            subtree: true
        });
    });
    INJECTED_STYLESHEETS.set(href, promise);
    return promise;
}
/**
 * @license Copyright (c) 2003-2025, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-licensing-options
 */ function isSSR() {
    return typeof window === "undefined";
}
/**
 * @license Copyright (c) 2003-2025, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-licensing-options
 */ function once(fn) {
    let lastResult = null;
    return (...args)=>{
        if (!lastResult) {
            lastResult = {
                current: fn(...args)
            };
        }
        return lastResult.current;
    };
}
/**
 * @license Copyright (c) 2003-2025, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-licensing-options
 */ function overwriteArray(source, destination) {
    destination.length = 0;
    destination.push(...source);
    return destination;
}
/**
 * @license Copyright (c) 2003-2025, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-licensing-options
 */ function overwriteObject(source, destination) {
    for (const prop of Object.getOwnPropertyNames(destination)){
        delete destination[prop];
    }
    for (const [key, value] of Object.entries(source)){
        if (value !== destination && key !== "prototype" && key !== "__proto__") {
            destination[key] = value;
        }
    }
    return destination;
}
/**
 * @license Copyright (c) 2003-2025, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-licensing-options
 */ function preloadResource(url, { attributes } = {}) {
    if (document.head.querySelector(`link[href="${url}"][rel="preload"]`)) {
        return;
    }
    const link = document.createElement("link");
    for (const [key, value] of Object.entries(attributes || {})){
        link.setAttribute(key, value);
    }
    link.setAttribute("data-injected-by", "ckeditor-integration");
    link.rel = "preload";
    link.as = detectTypeOfResource(url);
    link.href = url;
    document.head.insertBefore(link, document.head.firstChild);
}
function detectTypeOfResource(url) {
    switch(true){
        case /\.css$/.test(url):
            return "style";
        case /\.js$/.test(url):
            return "script";
        default:
            return "fetch";
    }
}
/**
 * @license Copyright (c) 2003-2025, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-licensing-options
 */ function shallowCompareArrays(a, b) {
    if (a === b) {
        return true;
    }
    if (!a || !b) {
        return false;
    }
    for(let i = 0; i < a.length; ++i){
        if (a[i] !== b[i]) {
            return false;
        }
    }
    return true;
}
/**
 * @license Copyright (c) 2003-2025, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-licensing-options
 */ const HEX_NUMBERS = new Array(256).fill("").map((_, index)=>("0" + index.toString(16)).slice(-2));
function uid() {
    const [r1, r2, r3, r4] = crypto.getRandomValues(new Uint32Array(4));
    return "e" + HEX_NUMBERS[r1 >> 0 & 255] + HEX_NUMBERS[r1 >> 8 & 255] + HEX_NUMBERS[r1 >> 16 & 255] + HEX_NUMBERS[r1 >> 24 & 255] + HEX_NUMBERS[r2 >> 0 & 255] + HEX_NUMBERS[r2 >> 8 & 255] + HEX_NUMBERS[r2 >> 16 & 255] + HEX_NUMBERS[r2 >> 24 & 255] + HEX_NUMBERS[r3 >> 0 & 255] + HEX_NUMBERS[r3 >> 8 & 255] + HEX_NUMBERS[r3 >> 16 & 255] + HEX_NUMBERS[r3 >> 24 & 255] + HEX_NUMBERS[r4 >> 0 & 255] + HEX_NUMBERS[r4 >> 8 & 255] + HEX_NUMBERS[r4 >> 16 & 255] + HEX_NUMBERS[r4 >> 24 & 255];
}
/**
 * @license Copyright (c) 2003-2025, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-licensing-options
 */ function uniq(source) {
    return Array.from(new Set(source));
}
/**
 * @license Copyright (c) 2003-2025, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-licensing-options
 */ async function waitForWindowEntry(entryNames, config) {
    const tryPickBundle = ()=>entryNames.map((name)=>window[name]).filter(Boolean)[0];
    return waitFor(()=>{
        const result = tryPickBundle();
        if (!result) {
            throw new Error(`Window entry "${entryNames.join(",")}" not found.`);
        }
        return result;
    }, config);
}
/**
 * @license Copyright (c) 2003-2025, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-licensing-options
 */ function filterObjectValues(obj, filter) {
    const filteredEntries = Object.entries(obj).filter(([key, value])=>filter(value, key));
    return Object.fromEntries(filteredEntries);
}
/**
 * @license Copyright (c) 2003-2025, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-licensing-options
 */ function filterBlankObjectValues(obj) {
    return filterObjectValues(obj, (value)=>value !== null && value !== void 0);
}
/**
 * @license Copyright (c) 2003-2025, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-licensing-options
 */ function mapObjectValues(obj, mapper) {
    const mappedEntries = Object.entries(obj).map(([key, value])=>[
            key,
            mapper(value, key)
        ]);
    return Object.fromEntries(mappedEntries);
}
/**
 * @license Copyright (c) 2003-2025, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-licensing-options
 */ function without(itemsToRemove, items) {
    return items.filter((item)=>!itemsToRemove.includes(item));
}
/**
 * @license Copyright (c) 2003-2025, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-licensing-options
 */ function appendExtraPluginsToEditorConfig(config, plugins) {
    const extraPlugins = config.extraPlugins || [];
    return {
        ...config,
        extraPlugins: [
            ...extraPlugins,
            ...plugins.filter((item)=>!extraPlugins.includes(item))
        ]
    };
}
/**
 * @license Copyright (c) 2003-2025, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-licensing-options
 */ function isSemanticVersion(version) {
    return !!version && /^\d+\.\d+\.\d+/.test(version);
}
/**
 * @license Copyright (c) 2003-2025, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-licensing-options
 */ function isCKCdnTestingVersion(version) {
    if (!version) {
        return false;
    }
    return [
        "nightly",
        "alpha",
        "internal",
        "nightly-",
        "staging"
    ].some((testVersion)=>version.includes(testVersion));
}
function isCKCdnVersion(version) {
    return isSemanticVersion(version) || isCKCdnTestingVersion(version);
}
/**
 * @license Copyright (c) 2003-2025, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-licensing-options
 */ function destructureSemanticVersion(version) {
    if (!isSemanticVersion(version)) {
        throw new Error(`Invalid semantic version: ${version || "<blank>"}.`);
    }
    const [major, minor, patch] = version.split(".");
    return {
        major: Number.parseInt(major, 10),
        minor: Number.parseInt(minor, 10),
        patch: Number.parseInt(patch, 10)
    };
}
/**
 * @license Copyright (c) 2003-2025, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-licensing-options
 */ function getLicenseVersionFromEditorVersion(version) {
    if (isCKCdnTestingVersion(version)) {
        return 3;
    }
    const { major } = destructureSemanticVersion(version);
    switch(true){
        case major >= 44:
            return 3;
        case major >= 38:
            return 2;
        default:
            return 1;
    }
}
/**
 * @license Copyright (c) 2003-2025, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-licensing-options
 */ function getCKBaseBundleInstallationInfo() {
    const { CKEDITOR_VERSION, CKEDITOR } = window;
    if (!isCKCdnVersion(CKEDITOR_VERSION)) {
        return null;
    }
    return {
        source: CKEDITOR ? "cdn" : "npm",
        version: CKEDITOR_VERSION
    };
}
/**
 * @license Copyright (c) 2003-2025, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-licensing-options
 */ function getSupportedLicenseVersionInstallationInfo() {
    const installationInfo = getCKBaseBundleInstallationInfo();
    if (!installationInfo) {
        return null;
    }
    return getLicenseVersionFromEditorVersion(installationInfo.version);
}
/**
 * @license Copyright (c) 2003-2025, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-licensing-options
 */ function isCKEditorFreeLicense(licenseKey, licenseVersion) {
    licenseVersion ||= getSupportedLicenseVersionInstallationInfo() || void 0;
    switch(licenseVersion){
        case 1:
        case 2:
            return licenseKey === void 0;
        case 3:
            return licenseKey === "GPL";
        default:
            {
                return false;
            }
    }
}
/**
 * @license Copyright (c) 2003-2025, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-licensing-options
 */ function createIntegrationUsageDataPlugin(integrationName, usageData) {
    return function IntegrationUsageDataPlugin(editor) {
        if (isCKEditorFreeLicense(editor.config.get("licenseKey"))) {
            return;
        }
        editor.on("collectUsageData", (source, { setUsageData })=>{
            setUsageData(`integration.${integrationName}`, usageData);
        });
    };
}
/**
 * @license Copyright (c) 2003-2025, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-licensing-options
 */ const CK_CDN_URL = "https://cdn.ckeditor.com";
function createCKCdnUrl(bundle, file, version) {
    return `${CK_CDN_URL}/${bundle}/${version}/${file}`;
}
/**
 * @license Copyright (c) 2003-2025, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-licensing-options
 */ const CKBOX_CDN_URL = "https://cdn.ckbox.io";
function createCKBoxCdnUrl(bundle, file, version) {
    return `${CKBOX_CDN_URL}/${bundle}/${version}/${file}`;
}
/**
 * @license Copyright (c) 2003-2025, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-licensing-options
 */ const CK_DOCS_URL = "https://ckeditor.com/docs/ckeditor5";
function createCKDocsUrl(path, version = "latest") {
    return `${CK_DOCS_URL}/${version}/${path}`;
}
/**
 * @license Copyright (c) 2003-2025, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-licensing-options
 */ function createCKCdnBaseBundlePack({ version, translations, createCustomCdnUrl = createCKCdnUrl }) {
    const urls = {
        scripts: [
            // Load the main script of the base features.
            createCustomCdnUrl("ckeditor5", "ckeditor5.umd.js", version),
            // Load all JavaScript files from the base features.
            // EN bundle is prebuilt into the main script, so we don't need to load it separately.
            ...without([
                "en"
            ], translations || []).map((translation)=>createCustomCdnUrl("ckeditor5", `translations/${translation}.umd.js`, version))
        ],
        stylesheets: [
            createCustomCdnUrl("ckeditor5", "ckeditor5.css", version)
        ]
    };
    return {
        // Preload resources specified in the pack, before loading the main script.
        preload: [
            ...urls.stylesheets,
            ...urls.scripts
        ],
        scripts: [
            // It's safe to load translations and the main script in parallel.
            async (attributes)=>injectScriptsInParallel(urls.scripts, attributes)
        ],
        // Load all stylesheets of the base features.
        stylesheets: urls.stylesheets,
        // Pick the exported global variables from the window object.
        checkPluginLoaded: async ()=>waitForWindowEntry([
                "CKEDITOR"
            ]),
        // Check if the CKEditor base bundle is already loaded and throw an error if it is.
        beforeInject: ()=>{
            const installationInfo = getCKBaseBundleInstallationInfo();
            switch(installationInfo?.source){
                case "npm":
                    throw new Error("CKEditor 5 is already loaded from npm. Check the migration guide for more details: " + createCKDocsUrl("updating/migration-to-cdn/vanilla-js.html"));
                case "cdn":
                    if (installationInfo.version !== version) {
                        throw new Error(`CKEditor 5 is already loaded from CDN in version ${installationInfo.version}. Remove the old <script> and <link> tags loading CKEditor 5 to allow loading the ${version} version.`);
                    }
                    break;
            }
        }
    };
}
/**
 * @license Copyright (c) 2003-2025, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-licensing-options
 */ function createCKCdnPremiumBundlePack({ version, translations, createCustomCdnUrl = createCKCdnUrl }) {
    const urls = {
        scripts: [
            // Load the main script of the premium features.
            createCustomCdnUrl("ckeditor5-premium-features", "ckeditor5-premium-features.umd.js", version),
            // Load all JavaScript files from the premium features.
            // EN bundle is prebuilt into the main script, so we don't need to load it separately.
            ...without([
                "en"
            ], translations || []).map((translation)=>createCustomCdnUrl("ckeditor5-premium-features", `translations/${translation}.umd.js`, version))
        ],
        stylesheets: [
            createCustomCdnUrl("ckeditor5-premium-features", "ckeditor5-premium-features.css", version)
        ]
    };
    return {
        // Preload resources specified in the pack, before loading the main script.
        preload: [
            ...urls.stylesheets,
            ...urls.scripts
        ],
        scripts: [
            // It's safe to load translations and the main script in parallel.
            async (attributes)=>injectScriptsInParallel(urls.scripts, attributes)
        ],
        // Load all stylesheets of the premium features.
        stylesheets: urls.stylesheets,
        // Pick the exported global variables from the window object.
        checkPluginLoaded: async ()=>waitForWindowEntry([
                "CKEDITOR_PREMIUM_FEATURES"
            ])
    };
}
/**
 * @license Copyright (c) 2003-2025, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-licensing-options
 */ async function loadCKCdnResourcesPack(pack) {
    let { htmlAttributes = {}, scripts = [], stylesheets = [], preload, beforeInject, checkPluginLoaded } = normalizeCKCdnResourcesPack(pack);
    beforeInject?.();
    if (!preload) {
        preload = uniq([
            ...stylesheets.filter((item)=>typeof item === "string"),
            ...scripts.filter((item)=>typeof item === "string")
        ]);
    }
    for (const url of preload){
        preloadResource(url, {
            attributes: htmlAttributes
        });
    }
    await Promise.all(uniq(stylesheets).map((href)=>injectStylesheet({
            href,
            attributes: htmlAttributes,
            placementInHead: "start"
        })));
    for (const script of uniq(scripts)){
        const injectorProps = {
            attributes: htmlAttributes
        };
        if (typeof script === "string") {
            await injectScript(script, injectorProps);
        } else {
            await script(injectorProps);
        }
    }
    return checkPluginLoaded?.();
}
function normalizeCKCdnResourcesPack(pack) {
    if (Array.isArray(pack)) {
        return {
            scripts: pack.filter((item)=>typeof item === "function" || item.endsWith(".js")),
            stylesheets: pack.filter((item)=>item.endsWith(".css"))
        };
    }
    if (typeof pack === "function") {
        return {
            checkPluginLoaded: pack
        };
    }
    return pack;
}
/**
 * @license Copyright (c) 2003-2025, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-licensing-options
 */ function combineCKCdnBundlesPacks(packs) {
    const normalizedPacks = mapObjectValues(filterBlankObjectValues(packs), normalizeCKCdnResourcesPack);
    const mergedPacks = Object.values(normalizedPacks).reduce((acc, pack)=>{
        acc.scripts.push(...pack.scripts ?? []);
        acc.stylesheets.push(...pack.stylesheets ?? []);
        acc.preload.push(...pack.preload ?? []);
        return acc;
    }, {
        preload: [],
        scripts: [],
        stylesheets: []
    });
    const checkPluginLoaded = async ()=>{
        const exportedGlobalVariables = /* @__PURE__ */ Object.create(null);
        for (const [name, pack] of Object.entries(normalizedPacks)){
            exportedGlobalVariables[name] = await pack?.checkPluginLoaded?.();
        }
        return exportedGlobalVariables;
    };
    const beforeInject = ()=>{
        for (const pack of Object.values(normalizedPacks)){
            pack.beforeInject?.();
        }
    };
    return {
        ...mergedPacks,
        beforeInject,
        checkPluginLoaded
    };
}
/**
 * @license Copyright (c) 2003-2025, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-licensing-options
 */ function getCKBoxInstallationInfo() {
    const version = window.CKBox?.version;
    if (!isSemanticVersion(version)) {
        return null;
    }
    return {
        source: "cdn",
        version
    };
}
/**
 * @license Copyright (c) 2003-2025, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-licensing-options
 */ function createCKBoxBundlePack({ version, theme = "lark", translations, createCustomCdnUrl = createCKBoxCdnUrl }) {
    return {
        // Load the main script of the base features.
        scripts: [
            createCustomCdnUrl("ckbox", "ckbox.js", version),
            // EN bundle is prebuilt into the main script, so we don't need to load it separately.
            ...without([
                "en"
            ], translations || []).map((translation)=>createCustomCdnUrl("ckbox", `translations/${translation}.js`, version))
        ],
        // Load optional theme, if provided. It's not required but recommended because it improves the look and feel.
        ...theme && {
            stylesheets: [
                createCustomCdnUrl("ckbox", `styles/themes/${theme}.css`, version)
            ]
        },
        // Pick the exported global variables from the window object.
        checkPluginLoaded: async ()=>waitForWindowEntry([
                "CKBox"
            ]),
        // Check if the CKBox bundle is already loaded and throw an error if it is.
        beforeInject: ()=>{
            const installationInfo = getCKBoxInstallationInfo();
            if (installationInfo && installationInfo.version !== version) {
                throw new Error(`CKBox is already loaded from CDN in version ${installationInfo.version}. Remove the old <script> and <link> tags loading CKBox to allow loading the ${version} version.`);
            }
        }
    };
}
/**
 * @license Copyright (c) 2003-2025, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-licensing-options
 */ function isCKCdnSupportedByEditorVersion(version) {
    if (isCKCdnTestingVersion(version)) {
        return true;
    }
    const { major } = destructureSemanticVersion(version);
    const licenseVersion = getLicenseVersionFromEditorVersion(version);
    switch(licenseVersion){
        case 3:
            return true;
        default:
            return major === 43;
    }
}
/**
 * @license Copyright (c) 2003-2025, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-licensing-options
 */ function combineCdnPluginsPacks(pluginsPacks) {
    const normalizedPluginsPacks = mapObjectValues(pluginsPacks, (pluginPack, pluginName)=>{
        if (!pluginPack) {
            return void 0;
        }
        const normalizedPluginPack = normalizeCKCdnResourcesPack(pluginPack);
        return {
            // Provide default window accessor object if the plugin pack does not define it.
            checkPluginLoaded: async ()=>waitForWindowEntry([
                    pluginName
                ]),
            // Transform the plugin pack to a normalized advanced pack.
            ...normalizedPluginPack
        };
    });
    return combineCKCdnBundlesPacks(normalizedPluginsPacks);
}
/**
 * @license Copyright (c) 2003-2025, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-licensing-options
 */ function loadCKEditorCloud(config) {
    const { version, translations, plugins, premium, ckbox, createCustomCdnUrl, injectedHtmlElementsAttributes = {
        crossorigin: "anonymous"
    } } = config;
    validateCKEditorVersion(version);
    const pack = combineCKCdnBundlesPacks({
        CKEditor: createCKCdnBaseBundlePack({
            version,
            translations,
            createCustomCdnUrl
        }),
        ...premium && {
            CKEditorPremiumFeatures: createCKCdnPremiumBundlePack({
                version,
                translations,
                createCustomCdnUrl
            })
        },
        ...ckbox && {
            CKBox: createCKBoxBundlePack(ckbox)
        },
        loadedPlugins: combineCdnPluginsPacks(plugins ?? {})
    });
    return loadCKCdnResourcesPack({
        ...pack,
        htmlAttributes: injectedHtmlElementsAttributes
    });
}
function validateCKEditorVersion(version) {
    if (isCKCdnTestingVersion(version)) {
        console.warn("You are using a testing version of CKEditor 5. Please remember that it is not suitable for production environments.");
    }
    if (!isCKCdnSupportedByEditorVersion(version)) {
        throw new Error(`The CKEditor 5 CDN can't be used with the given editor version: ${version}. Please make sure you are using at least the CKEditor 5 version 44.`);
    }
}
;
 //# sourceMappingURL=index.js.map
}}),
"[project]/node_modules/@ckeditor/ckeditor5-react/dist/index.js [app-client] (ecmascript) <locals>": ((__turbopack_context__) => {
"use strict";

var { g: global, __dirname } = __turbopack_context__;
{
__turbopack_context__.s({
    "CKEditor": (()=>CKEditor),
    "CKEditorContext": (()=>CKEditorContext),
    "useCKEditorCloud": (()=>useCKEditorCloud),
    "useMultiRootEditor": (()=>useMultiRootEditor),
    "withCKEditorCloud": (()=>withCKEditorCloud)
});
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$index$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/next/dist/compiled/react/index.js [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f40$ckeditor$2f$ckeditor5$2d$integrations$2d$common$2f$dist$2f$index$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/@ckeditor/ckeditor5-integrations-common/dist/index.js [app-client] (ecmascript)");
var __defProp = Object.defineProperty;
var __defNormalProp = (obj, key, value)=>key in obj ? __defProp(obj, key, {
        enumerable: true,
        configurable: true,
        writable: true,
        value
    }) : obj[key] = value;
var __publicField = (obj, key, value)=>__defNormalProp(obj, typeof key !== "symbol" ? key + "" : key, value);
;
;
;
/**
 * @license Copyright (c) 2003-2025, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-licensing-options
 */ const _LifeCycleElementSemaphore = class _LifeCycleElementSemaphore {
    constructor(element, lifecycle){
        /**
     * This should define async methods for initializing and destroying the editor.
     * Essentially, it's an async version of basic React lifecycle methods like `componentDidMount`, `componentWillUnmount`.
     *
     * 	* Result of {@link LifeCycleAsyncOperators#mount} method is passed to {@link LifeCycleAsyncOperators#unmount} as an argument.
     */ __publicField(this, "_lifecycle");
        /**
     * This is the element instance that the editor uses for mounting. This element should contain the `ckeditorInstance` member
     * once the editor has been successfully mounted to it. The semaphore ensures that a new instance of the editor, which will
     * be assigned to this element by the {@link #_lifecycle:mount} method, will always be initialized after the successful
     * destruction of the underlying `ckeditorInstance` that was previously mounted on this element.
     */ __publicField(this, "_element");
        /**
     * This is the lock mechanism utilized by the {@link #lock} and {@link #release} methods.
     *
     * 	* If the editor is not yet mounted and is awaiting mounting (for instance, when another editor is
     * 	  occupying the element), then it is null.
     *
     * 	* When the editor is mounted on the element, this variable holds an unresolved promise that will be
     * 	  resolved after the editor is destroyed.
     *
     * 	* Once the editor is destroyed (and it was previously mounted), the promise is resolved.
     */ __publicField(this, "_releaseLock", null);
        /**
     * This is the result of the {@link #_lifecycle:mount} function. This value should be reset to `null`
     * once the semaphore is released. It is utilized to store certain data that must be removed following
     * the destruction of the editor. This data may include the editor's instance, the assigned watchdog,
     * or handles for additional window listeners.
     */ __publicField(this, "_value", null);
        /**
     * This is a list of callbacks that are triggered if the semaphore {@link #_lifecycle:mount} method executes successfully.
     * It is utilized in scenarios where we need to assign certain properties to an editor that is currently in the process of mounting.
     * An instance of such usage could be two-way binding. We aim to prevent the loss of all `setData` calls if the editor has not
     * yet been mounted, therefore these calls will be executed immediately following the completion of the mounting process.
     */ __publicField(this, "_afterMountCallbacks", []);
        /**
     * This represents the actual mounting state of the semaphore. It is primarily used by the {@link #release} method to
     * determine whether the initialization of the editor should be skipped or, if the editor is already initialized, the editor
     * should be destroyed.
     *
     * 	* If `destroyedBeforeInitialization` is true, then the {@link #release} method was invoked before the editor began to mount.
     * 	  This often occurs in strict mode when we assign a promise to the {@link LifeCycleEditorElementSemaphore#_semaphores} map
     * 	  and the assigned `mount` callback has not yet been called. In this scenario, it is safe to skip the initialization of the editor
     * 	  and simply release the semaphore.
     *
     *	* If `mountingInProgress` is a Promise, then the {@link #release} method was invoked after the initialization of the editor and
     	  the editor must be destroyed before the semaphore is released.
    */ __publicField(this, "_state", {
            destroyedBeforeInitialization: false,
            mountingInProgress: null
        });
        /**
     * Inverse of {@link #_lock} method that tries to destroy attached editor.
     *
     * 	* If editor is being already attached to element (or is in attaching process) then after fully initialization of editor
     * 	  destroy is performed and semaphore is released. The {@link #_lifecycle} unmount method is called.
     *
     * 	* If editor is being destroyed before initialization then it does nothing but sets `destroyedBeforeInitialization` flag that
     * 	  will be later checked by {@link #_lock} method in initialization. The {@link #_lifecycle} unmount method is not called.
     *
     * *Important note:*
     *
     * It’s really important to keep this method *sync*. If we make this method *async*, it won’t work well because
     * it will cause problems when we’re trying to set up the {@link LifeCycleEditorElementSemaphore#_semaphores} map entries.
     */ __publicField(this, "release", (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f40$ckeditor$2f$ckeditor5$2d$integrations$2d$common$2f$dist$2f$index$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["once"])(()=>{
            const { _releaseLock, _state, _element, _lifecycle } = this;
            if (_state.mountingInProgress) {
                _state.mountingInProgress.then(()=>_lifecycle.unmount({
                        element: _element,
                        // Mount result might be overridden by watchdog during restart so use instance variable.
                        mountResult: this.value
                    })).catch((error)=>{
                    console.error("Semaphore unmounting error:", error);
                }).then(_releaseLock.resolve).then(()=>{
                    this._value = null;
                });
            } else {
                _state.destroyedBeforeInitialization = true;
                _releaseLock.resolve();
            }
        }));
        this._element = element;
        this._lifecycle = lifecycle;
        this._lock();
    }
    /**
   * Getter for {@link #_value}.
   */ get value() {
        return this._value;
    }
    /**
   * Occasionally, the Watchdog restarts the editor instance, resulting in a new instance being assigned to the semaphore.
   * In terms of race conditions, it's generally safer to simply override the semaphore value rather than recreating it
   * with a different one.
   */ unsafeSetValue(value) {
        this._value = value;
        this._afterMountCallbacks.forEach((callback)=>callback(value));
        this._afterMountCallbacks = [];
    }
    /**
   * This registers a callback that will be triggered after the editor has been successfully mounted.
   *
   * 	* If the editor is already mounted, the callback will be executed immediately.
   *	* If the editor is in the process of mounting, the callback will be executed upon successful mounting.
  * 	* If the editor is never mounted, the passed callback will not be executed.
  * 	* If an exception is thrown within the callback, it will be re-thrown in the semaphore.
  */ runAfterMount(callback) {
        const { _value, _afterMountCallbacks } = this;
        if (_value) {
            callback(_value);
        } else {
            _afterMountCallbacks.push(callback);
        }
    }
    /**
   * This method is used to inform other components that the {@link #_element} will be used by the editor,
   * which is initialized by the {@link #_lifecycle} methods.
   *
   * 	* If an editor is already present on the provided element, the initialization of the current one
   * 	  will be postponed until the previous one is destroyed.
   *
   * 	* If the element is empty and does not have an editor attached to it, the currently locked editor will
   * 	  be mounted immediately.
   *
   * After the successful initialization of the editor and the assignment of the {@link #_value} member,
   * the `onReady` lifecycle method is called.
   *
   * *Important note:*
   *
   * It’s really important to keep this method *sync*. If we make this method *async*, it won’t work well because
   * it will cause problems when we’re trying to set up the {@link LifeCycleEditorElementSemaphore#_semaphores} map entries.
   */ _lock() {
        const { _semaphores } = _LifeCycleElementSemaphore;
        const { _state, _element, _lifecycle } = this;
        const prevElementSemaphore = _semaphores.get(_element) || Promise.resolve(null);
        const releaseLock = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f40$ckeditor$2f$ckeditor5$2d$integrations$2d$common$2f$dist$2f$index$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["createDefer"])();
        this._releaseLock = releaseLock;
        const newElementSemaphore = prevElementSemaphore.then(()=>{
            if (_state.destroyedBeforeInitialization) {
                return Promise.resolve(void 0);
            }
            _state.mountingInProgress = _lifecycle.mount().then((mountResult)=>{
                if (mountResult) {
                    this.unsafeSetValue(mountResult);
                }
                return mountResult;
            });
            return _state.mountingInProgress;
        }).then(async (mountResult)=>{
            if (mountResult && _lifecycle.afterMount) {
                await _lifecycle.afterMount({
                    element: _element,
                    mountResult
                });
            }
        }).then(()=>releaseLock.promise).catch((error)=>{
            console.error("Semaphore mounting error:", error);
        }).then(()=>{
            if (_semaphores.get(_element) === newElementSemaphore) {
                _semaphores.delete(_element);
            }
        });
        _semaphores.set(_element, newElementSemaphore);
    }
};
/**
 * This is a map of elements associated with promises. It informs the semaphore that the underlying HTML element, used as a key,
 * is currently in use by another editor. Each element is assigned a promise, which allows for the easy chaining of new
 * editor instances on an element that is already in use by another instance. The process works as follows:
 *
 * 	1. If an element is being used by an editor, then the initialization of a new editor
 * 	   instance is chained using the `.then()` method of the Promise.
 *
 * 	2. If the editor associated with the underlying element is destroyed, then `Promise.resolve()` is called
 * 	   and the previously assigned `.then()` editor callback is executed.
 *
 *  @see {@link #lock} for more detailed information on the implementation.
 */ __publicField(_LifeCycleElementSemaphore, "_semaphores", /* @__PURE__ */ new Map());
let LifeCycleElementSemaphore = _LifeCycleElementSemaphore;
/**
 * @license Copyright (c) 2003-2025, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-licensing-options
 */ const ReactContextMetadataKey = "$__CKEditorReactContextMetadata";
function withCKEditorReactContextMetadata(metadata, config) {
    return {
        ...config,
        [ReactContextMetadataKey]: metadata
    };
}
function tryExtractCKEditorReactContextMetadata(object) {
    return object.get(ReactContextMetadataKey);
}
/**
 * @license Copyright (c) 2003-2025, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-licensing-options
 */ const useIsMountedRef = ()=>{
    const mountedRef = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$index$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["useRef"])(false);
    (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$index$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["useEffect"])({
        "useIsMountedRef.useEffect": ()=>{
            mountedRef.current = true;
            return ({
                "useIsMountedRef.useEffect": ()=>{
                    mountedRef.current = false;
                }
            })["useIsMountedRef.useEffect"];
        }
    }["useIsMountedRef.useEffect"], []);
    return mountedRef;
};
/**
 * @license Copyright (c) 2003-2025, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-licensing-options
 */ const useRefSafeCallback = (fn)=>{
    const callbackRef = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$index$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["useRef"])();
    callbackRef.current = fn;
    return (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$index$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["useCallback"])({
        "useRefSafeCallback.useCallback": (...args)=>callbackRef.current(...args)
    }["useRefSafeCallback.useCallback"], []);
};
/**
 * @license Copyright (c) 2003-2025, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-licensing-options
 */ const useInitializedCKEditorsMap = ({ currentContextWatchdog, onChangeInitializedEditors })=>{
    const onChangeInitializedEditorsSafe = useRefSafeCallback(onChangeInitializedEditors || ({
        "useInitializedCKEditorsMap.useRefSafeCallback[onChangeInitializedEditorsSafe]": ()=>{}
    })["useInitializedCKEditorsMap.useRefSafeCallback[onChangeInitializedEditorsSafe]"]);
    (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$index$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["useEffect"])({
        "useInitializedCKEditorsMap.useEffect": ()=>{
            var _a;
            if (currentContextWatchdog.status !== "initialized") {
                return;
            }
            const { watchdog } = currentContextWatchdog;
            const editors = (_a = watchdog == null ? void 0 : watchdog.context) == null ? void 0 : _a.editors;
            if (!editors) {
                return;
            }
            const getInitializedContextEditors = {
                "useInitializedCKEditorsMap.useEffect.getInitializedContextEditors": ()=>[
                        ...editors
                    ].reduce({
                        "useInitializedCKEditorsMap.useEffect.getInitializedContextEditors": (map, editor)=>{
                            var _a2;
                            if (editor.state !== "ready") {
                                return map;
                            }
                            const metadata = tryExtractCKEditorReactContextMetadata(editor.config);
                            const nameOrId = (_a2 = metadata == null ? void 0 : metadata.name) != null ? _a2 : editor.id;
                            map[nameOrId] = {
                                instance: editor,
                                metadata
                            };
                            return map;
                        }
                    }["useInitializedCKEditorsMap.useEffect.getInitializedContextEditors"], /* @__PURE__ */ Object.create({}))
            }["useInitializedCKEditorsMap.useEffect.getInitializedContextEditors"];
            const onEditorStatusChange = {
                "useInitializedCKEditorsMap.useEffect.onEditorStatusChange": ()=>{
                    onChangeInitializedEditorsSafe(getInitializedContextEditors(), watchdog);
                }
            }["useInitializedCKEditorsMap.useEffect.onEditorStatusChange"];
            const trackEditorLifecycle = {
                "useInitializedCKEditorsMap.useEffect.trackEditorLifecycle": (editor)=>{
                    editor.once("ready", onEditorStatusChange, {
                        priority: "lowest"
                    });
                    editor.once("destroy", onEditorStatusChange, {
                        priority: "lowest"
                    });
                }
            }["useInitializedCKEditorsMap.useEffect.trackEditorLifecycle"];
            const onAddEditorToCollection = {
                "useInitializedCKEditorsMap.useEffect.onAddEditorToCollection": (_, editor)=>{
                    trackEditorLifecycle(editor);
                }
            }["useInitializedCKEditorsMap.useEffect.onAddEditorToCollection"];
            editors.forEach(trackEditorLifecycle);
            editors.on("add", onAddEditorToCollection);
            if (Array.from(editors).some({
                "useInitializedCKEditorsMap.useEffect": (editor)=>editor.state === "ready"
            }["useInitializedCKEditorsMap.useEffect"])) {
                onEditorStatusChange();
            }
            return ({
                "useInitializedCKEditorsMap.useEffect": ()=>{
                    editors.off("add", onAddEditorToCollection);
                }
            })["useInitializedCKEditorsMap.useEffect"];
        }
    }["useInitializedCKEditorsMap.useEffect"], [
        currentContextWatchdog
    ]);
};
/**
 * @license Copyright (c) 2003-2025, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-licensing-options
 */ const ContextWatchdogContext = __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$index$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["default"].createContext(null);
const CKEditorContext = (props)=>{
    const { id, context, watchdogConfig, children, config, onReady, contextWatchdog: ContextWatchdogConstructor, isLayoutReady = true, onChangeInitializedEditors, onError = (error, details)=>console.error(error, details) } = props;
    const isMountedRef = useIsMountedRef();
    const prevWatchdogInitializationIDRef = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$index$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["useRef"])(null);
    const [currentContextWatchdog, setCurrentContextWatchdog] = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$index$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["useState"])({
        status: "initializing"
    });
    (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$index$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["useEffect"])({
        "CKEditorContext.useEffect": ()=>{
            if (isLayoutReady) {
                initializeContextWatchdog();
            } else {
                setCurrentContextWatchdog({
                    status: "initializing"
                });
            }
        }
    }["CKEditorContext.useEffect"], [
        id,
        isLayoutReady
    ]);
    (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$index$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["useEffect"])({
        "CKEditorContext.useEffect": ()=>({
                "CKEditorContext.useEffect": ()=>{
                    if (currentContextWatchdog.status === "initialized") {
                        currentContextWatchdog.watchdog.destroy();
                    }
                }
            })["CKEditorContext.useEffect"]
    }["CKEditorContext.useEffect"], [
        currentContextWatchdog
    ]);
    useInitializedCKEditorsMap({
        currentContextWatchdog,
        onChangeInitializedEditors
    });
    function regenerateInitializationID() {
        prevWatchdogInitializationIDRef.current = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f40$ckeditor$2f$ckeditor5$2d$integrations$2d$common$2f$dist$2f$index$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["uid"])();
        return prevWatchdogInitializationIDRef.current;
    }
    function canUpdateState(initializationID) {
        return prevWatchdogInitializationIDRef.current === initializationID && isMountedRef.current;
    }
    function initializeContextWatchdog() {
        const watchdogInitializationID = regenerateInitializationID();
        const contextWatchdog = new ContextWatchdogConstructor(context, watchdogConfig);
        contextWatchdog.on("error", (_, errorEvent)=>{
            /* istanbul ignore else -- @preserve */ if (canUpdateState(watchdogInitializationID)) {
                onError(errorEvent.error, {
                    phase: "runtime",
                    willContextRestart: errorEvent.causesRestart
                });
            }
        });
        contextWatchdog.on("stateChange", ()=>{
            if (onReady && contextWatchdog.state === "ready" && canUpdateState(watchdogInitializationID)) {
                onReady(contextWatchdog.context, contextWatchdog);
            }
        });
        contextWatchdog.create(config).then(()=>{
            if (canUpdateState(watchdogInitializationID)) {
                setCurrentContextWatchdog({
                    status: "initialized",
                    watchdog: contextWatchdog
                });
            } else {
                contextWatchdog.destroy();
            }
        }).catch((error)=>{
            if (canUpdateState(watchdogInitializationID)) {
                onError(error, {
                    phase: "initialization",
                    willContextRestart: false
                });
                setCurrentContextWatchdog({
                    status: "error",
                    error
                });
            }
        });
        return contextWatchdog;
    }
    return /* @__PURE__ */ __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$index$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["default"].createElement(ContextWatchdogContext.Provider, {
        value: currentContextWatchdog
    }, children);
};
const isContextWatchdogValue = (obj)=>!!obj && typeof obj === "object" && "status" in obj && [
        "initializing",
        "initialized",
        "error"
    ].includes(obj.status);
const isContextWatchdogValueWithStatus = (status)=>(obj)=>isContextWatchdogValue(obj) && obj.status === status;
const isContextWatchdogInitializing = isContextWatchdogValueWithStatus("initializing");
const isContextWatchdogReadyToUse = (obj)=>isContextWatchdogValueWithStatus("initialized")(obj) && obj.watchdog.state === "ready";
/**
 * @license Copyright (c) 2003-2025, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-licensing-options
 */ const ReactIntegrationUsageDataPlugin = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f40$ckeditor$2f$ckeditor5$2d$integrations$2d$common$2f$dist$2f$index$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["createIntegrationUsageDataPlugin"])("react", {
    version: "9.5.0",
    frameworkVersion: __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$index$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["default"].version
});
/**
 * @license Copyright (c) 2003-2025, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-licensing-options
 */ function appendAllIntegrationPluginsToConfig(editorConfig) {
    if ((0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f40$ckeditor$2f$ckeditor5$2d$integrations$2d$common$2f$dist$2f$index$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["isCKEditorFreeLicense"])(editorConfig.licenseKey)) {
        return editorConfig;
    }
    return (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f40$ckeditor$2f$ckeditor5$2d$integrations$2d$common$2f$dist$2f$index$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["appendExtraPluginsToEditorConfig"])(editorConfig, [
        /**
     * This part of the code is not executed in open-source implementations using a GPL key.
     * It only runs when a specific license key is provided. If you are uncertain whether
     * this applies to your installation, please contact our support team.
     */ ReactIntegrationUsageDataPlugin
    ]);
}
/**
 * @license Copyright (c) 2003-2025, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-licensing-options
 */ const REACT_INTEGRATION_READ_ONLY_LOCK_ID$1 = "Lock from React integration (@ckeditor/ckeditor5-react)";
class CKEditor extends __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$index$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["default"].Component {
    constructor(props){
        super(props);
        /**
     * After mounting the editor, the variable will contain a reference to the created editor.
     * @see: https://ckeditor.com/docs/ckeditor5/latest/api/module_core_editor_editor-Editor.html
     */ __publicField(this, "domContainer", __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$index$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["default"].createRef());
        /**
     * Unlocks element in editor semaphore after destroy editor instance.
     */ __publicField(this, "editorSemaphore", null);
        this._checkVersion();
    }
    /**
   * Checks if the CKEditor version used in the application is compatible with the component.
   */ _checkVersion() {
        const { CKEDITOR_VERSION } = window;
        if (!CKEDITOR_VERSION) {
            return console.warn('Cannot find the "CKEDITOR_VERSION" in the "window" scope.');
        }
        const [major] = CKEDITOR_VERSION.split(".").map(Number);
        if (major >= 42 || CKEDITOR_VERSION.startsWith("0.0.0")) {
            return;
        }
        console.warn("The <CKEditor> component requires using CKEditor 5 in version 42+ or nightly build.");
    }
    get _semaphoreValue() {
        const { editorSemaphore } = this;
        return editorSemaphore ? editorSemaphore.value : null;
    }
    /**
   * An watchdog instance.
   */ get watchdog() {
        const { _semaphoreValue } = this;
        return _semaphoreValue ? _semaphoreValue.watchdog : null;
    }
    /**
   * An editor instance.
   */ get editor() {
        const { _semaphoreValue } = this;
        return _semaphoreValue ? _semaphoreValue.instance : null;
    }
    /**
   * The CKEditor component should not be updated by React itself.
   * However, if the component identifier changes, the whole structure should be created once again.
   */ shouldComponentUpdate(nextProps) {
        const { props, editorSemaphore } = this;
        if (nextProps.id !== props.id) {
            return true;
        }
        if (nextProps.disableWatchdog !== props.disableWatchdog) {
            return true;
        }
        if (editorSemaphore) {
            editorSemaphore.runAfterMount(({ instance })=>{
                if (this._shouldUpdateEditorData(props, nextProps, instance)) {
                    instance.data.set(nextProps.data);
                }
            });
            if ("disabled" in nextProps) {
                editorSemaphore.runAfterMount(({ instance })=>{
                    if (nextProps.disabled) {
                        instance.enableReadOnlyMode(REACT_INTEGRATION_READ_ONLY_LOCK_ID$1);
                    } else {
                        instance.disableReadOnlyMode(REACT_INTEGRATION_READ_ONLY_LOCK_ID$1);
                    }
                });
            }
        }
        return false;
    }
    /**
   * Initialize the editor when the component is mounted.
   */ componentDidMount() {
        if (!isContextWatchdogInitializing(this.context)) {
            this._initLifeCycleSemaphore();
        }
    }
    /**
   * Re-render the entire component once again. The old editor will be destroyed and the new one will be created.
   */ componentDidUpdate() {
        if (!isContextWatchdogInitializing(this.context)) {
            this._initLifeCycleSemaphore();
        }
    }
    /**
   * Destroy the editor before unmounting the component.
   */ componentWillUnmount() {
        this._unlockLifeCycleSemaphore();
    }
    /**
   * Async destroy attached editor and unlock element semaphore.
   */ _unlockLifeCycleSemaphore() {
        if (this.editorSemaphore) {
            this.editorSemaphore.release();
            this.editorSemaphore = null;
        }
    }
    /**
   * Unlocks previous editor semaphore and creates new one..
   */ _initLifeCycleSemaphore() {
        this._unlockLifeCycleSemaphore();
        this.editorSemaphore = new LifeCycleElementSemaphore(this.domContainer.current, {
            mount: async ()=>this._initializeEditor(),
            afterMount: ({ mountResult })=>{
                const { onReady } = this.props;
                if (onReady && this.domContainer.current !== null) {
                    onReady(mountResult.instance);
                }
            },
            unmount: async ({ element, mountResult })=>{
                const { onAfterDestroy } = this.props;
                try {
                    await this._destroyEditor(mountResult);
                    element.innerHTML = "";
                } finally{
                    if (onAfterDestroy) {
                        onAfterDestroy(mountResult.instance);
                    }
                }
            }
        });
    }
    /**
   * Render a <div> element which will be replaced by CKEditor.
   */ render() {
        return /* @__PURE__ */ __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$index$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["default"].createElement("div", {
            ref: this.domContainer
        });
    }
    /**
   * Initializes the editor by creating a proper watchdog and initializing it with the editor's configuration.
   */ async _initializeEditor() {
        if (this.props.disableWatchdog) {
            const instance = await this._createEditor(this.domContainer.current, this._getConfig());
            return {
                instance,
                watchdog: null
            };
        }
        const watchdog = (()=>{
            if (isContextWatchdogReadyToUse(this.context)) {
                return new EditorWatchdogAdapter(this.context.watchdog);
            }
            return new this.props.editor.EditorWatchdog(this.props.editor, this.props.watchdogConfig);
        })();
        const totalRestartsRef = {
            current: 0
        };
        watchdog.setCreator(async (el, config)=>{
            var _a;
            const { editorSemaphore } = this;
            const { onAfterDestroy } = this.props;
            if (totalRestartsRef.current > 0 && onAfterDestroy && ((_a = editorSemaphore == null ? void 0 : editorSemaphore.value) == null ? void 0 : _a.instance)) {
                onAfterDestroy(editorSemaphore.value.instance);
            }
            const instance = await this._createEditor(el, config);
            if (editorSemaphore && totalRestartsRef.current > 0) {
                editorSemaphore.unsafeSetValue({
                    instance,
                    watchdog
                });
                setTimeout(()=>{
                    if (this.props.onReady) {
                        this.props.onReady(watchdog.editor);
                    }
                });
            }
            totalRestartsRef.current++;
            return instance;
        });
        watchdog.on("error", (_, { error, causesRestart })=>{
            const onError = this.props.onError || console.error;
            onError(error, {
                phase: "runtime",
                willEditorRestart: causesRestart
            });
        });
        await watchdog.create(this.domContainer.current, this._getConfig()).catch((error)=>{
            const onError = this.props.onError || console.error;
            onError(error, {
                phase: "initialization",
                willEditorRestart: false
            });
        });
        return {
            watchdog,
            instance: watchdog.editor
        };
    }
    /**
   * Creates an editor from the element and configuration.
   *
   * @param element The source element.
   * @param config CKEditor 5 editor configuration.
   */ _createEditor(element, config) {
        const { contextItemMetadata } = this.props;
        if (contextItemMetadata) {
            config = withCKEditorReactContextMetadata(contextItemMetadata, config);
        }
        return this.props.editor.create(element, appendAllIntegrationPluginsToConfig(config)).then((editor)=>{
            if ("disabled" in this.props) {
                /* istanbul ignore else -- @preserve */ if (this.props.disabled) {
                    editor.enableReadOnlyMode(REACT_INTEGRATION_READ_ONLY_LOCK_ID$1);
                }
            }
            const modelDocument = editor.model.document;
            const viewDocument = editor.editing.view.document;
            modelDocument.on("change:data", (event)=>{
                /* istanbul ignore else -- @preserve */ if (this.props.onChange) {
                    this.props.onChange(event, editor);
                }
            });
            viewDocument.on("focus", (event)=>{
                /* istanbul ignore else -- @preserve */ if (this.props.onFocus) {
                    this.props.onFocus(event, editor);
                }
            });
            viewDocument.on("blur", (event)=>{
                /* istanbul ignore else -- @preserve */ if (this.props.onBlur) {
                    this.props.onBlur(event, editor);
                }
            });
            return editor;
        });
    }
    /**
   * Destroys the editor by destroying the watchdog.
   */ async _destroyEditor(initializeResult) {
        const { watchdog, instance } = initializeResult;
        return new Promise((resolve, reject)=>{
            /* istanbul ignore next -- @preserve */ setTimeout(async ()=>{
                try {
                    if (watchdog) {
                        await watchdog.destroy();
                        return resolve();
                    }
                    if (instance) {
                        await instance.destroy();
                        return resolve();
                    }
                    resolve();
                } catch (e) {
                    console.error(e);
                    reject(e);
                }
            });
        });
    }
    /**
   * Returns true when the editor should be updated.
   *
   * @param prevProps Previous react's properties.
   * @param nextProps React's properties.
   * @param editor Current editor instance.
   */ _shouldUpdateEditorData(prevProps, nextProps, editor) {
        if (prevProps.data === nextProps.data) {
            return false;
        }
        if (editor.data.get() === nextProps.data) {
            return false;
        }
        return true;
    }
    /**
   * Returns the editor configuration.
   */ _getConfig() {
        const config = this.props.config || {};
        if (this.props.data && config.initialData) {
            console.warn("Editor data should be provided either using `config.initialData` or `content` property. The config value takes precedence over `content` property and will be used when both are specified.");
        }
        return {
            ...config,
            initialData: config.initialData || this.props.data || ""
        };
    }
}
__publicField(CKEditor, "contextType", ContextWatchdogContext);
class EditorWatchdogAdapter {
    /**
   * @param contextWatchdog The context watchdog instance that will be wrapped into editor watchdog API.
   */ constructor(contextWatchdog){
        /**
     * The context watchdog instance that will be wrapped into editor watchdog API.
     */ __publicField(this, "_contextWatchdog");
        /**
     * A unique id for the adapter to distinguish editor items when using the context watchdog API.
     */ __publicField(this, "_id");
        /**
     * A watchdog's editor creator function.
     */ __publicField(this, "_creator");
        this._contextWatchdog = contextWatchdog;
        this._id = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f40$ckeditor$2f$ckeditor5$2d$integrations$2d$common$2f$dist$2f$index$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["uid"])();
    }
    /**
   *  @param creator A watchdog's editor creator function.
   */ setCreator(creator) {
        this._creator = creator;
    }
    /**
   * Adds an editor configuration to the context watchdog registry. Creates an instance of it.
   *
   * @param sourceElementOrData A source element or data for the new editor.
   * @param config CKEditor 5 editor config.
   */ create(sourceElementOrData, config) {
        return this._contextWatchdog.add({
            sourceElementOrData,
            config,
            creator: this._creator,
            id: this._id,
            type: "editor"
        });
    }
    /**
   * Creates a listener that is attached to context watchdog's item and run when the context watchdog fires.
   * Currently works only for the `error` event.
   */ on(_, callback) {
        this._contextWatchdog.on("itemError", (_2, { itemId, error })=>{
            if (itemId === this._id) {
                callback(null, {
                    error,
                    causesRestart: void 0
                });
            }
        });
    }
    destroy() {
        if (this._contextWatchdog.state === "ready") {
            return this._contextWatchdog.remove(this._id);
        }
        return Promise.resolve();
    }
    /**
   * An editor instance.
   */ get editor() {
        return this._contextWatchdog.getItem(this._id);
    }
}
/**
 * @license Copyright (c) 2003-2025, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-licensing-options
 */ const useLifeCycleSemaphoreSyncRef = ()=>{
    const semaphoreRef = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$index$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["useRef"])(null);
    const [revision, setRevision] = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$index$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["useState"])({
        "useLifeCycleSemaphoreSyncRef.useState": ()=>Date.now()
    }["useLifeCycleSemaphoreSyncRef.useState"]);
    const refresh = ()=>{
        setRevision(Date.now());
    };
    const release = (rerender = true)=>{
        if (semaphoreRef.current) {
            semaphoreRef.current.release();
            semaphoreRef.current = null;
        }
        if (rerender) {
            setRevision(Date.now());
        }
    };
    const unsafeSetValue = (value)=>{
        var _a;
        (_a = semaphoreRef.current) == null ? void 0 : _a.unsafeSetValue(value);
        refresh();
    };
    const runAfterMount = (callback)=>{
        if (semaphoreRef.current) {
            semaphoreRef.current.runAfterMount(callback);
        }
    };
    const replace = (newSemaphore)=>{
        release(false);
        semaphoreRef.current = newSemaphore();
        refresh();
        runAfterMount(refresh);
    };
    const createAttributeRef = (key)=>({
            get current () {
                if (!semaphoreRef.current || !semaphoreRef.current.value) {
                    return null;
                }
                return semaphoreRef.current.value[key];
            }
        });
    return {
        get current () {
            return semaphoreRef.current;
        },
        revision,
        createAttributeRef,
        unsafeSetValue,
        release,
        replace,
        runAfterMount
    };
};
/**
 * @license Copyright (c) 2003-2025, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-licensing-options
 */ function mergeRefs(...refs) {
    return (value)=>{
        refs.forEach((ref)=>{
            if (typeof ref === "function") {
                ref(value);
            } else if (ref != null) {
                ref.current = value;
            }
        });
    };
}
/**
 * @license Copyright (c) 2003-2025, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-licensing-options
 */ const useInstantEffect = (fn, deps)=>{
    const [prevDeps, setDeps] = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$index$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["useState"])(null);
    if (!(0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f40$ckeditor$2f$ckeditor5$2d$integrations$2d$common$2f$dist$2f$index$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["shallowCompareArrays"])(prevDeps, deps)) {
        fn();
        setDeps([
            ...deps
        ]);
    }
};
/**
 * @license Copyright (c) 2003-2025, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-licensing-options
 */ const useInstantEditorEffect = (semaphore, fn, deps)=>{
    useInstantEffect({
        "useInstantEditorEffect.useInstantEffect": ()=>{
            if (semaphore) {
                semaphore.runAfterMount(fn);
            }
        }
    }["useInstantEditorEffect.useInstantEffect"], [
        semaphore,
        ...deps
    ]);
};
/**
 * @license Copyright (c) 2003-2025, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-licensing-options
 */ const REACT_INTEGRATION_READ_ONLY_LOCK_ID = "Lock from React integration (@ckeditor/ckeditor5-react)";
const useMultiRootEditor = (props)=>{
    const semaphoreElementRef = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$index$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["useRef"])(props.semaphoreElement || null);
    const semaphore = useLifeCycleSemaphoreSyncRef();
    const editorRefs = {
        watchdog: semaphore.createAttributeRef("watchdog"),
        instance: semaphore.createAttributeRef("instance")
    };
    const context = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$index$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["useContext"])(ContextWatchdogContext);
    const [roots, setRoots] = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$index$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["useState"])({
        "useMultiRootEditor.useState": ()=>Object.keys(props.data)
    }["useMultiRootEditor.useState"]);
    const [data, setData] = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$index$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["useState"])({
        ...props.data
    });
    const [attributes, setAttributes] = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$index$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["useState"])({
        ...props.rootsAttributes
    });
    const shouldUpdateEditor = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$index$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["useRef"])(true);
    const forceAssignFakeEditableElements = ()=>{
        const editor = editorRefs.instance.current;
        if (!editor) {
            return;
        }
        const initializeEditableWithFakeElement = (editable)=>{
            if (editable.name && !editor.editing.view.getDomRoot(editable.name)) {
                editor.editing.view.attachDomRoot(document.createElement("div"), editable.name);
            }
        };
        Object.values(editor.ui.view.editables).forEach(initializeEditableWithFakeElement);
    };
    (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$index$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["useEffect"])({
        "useMultiRootEditor.useEffect": ()=>{
            const semaphoreElement = semaphoreElementRef.current;
            if (context && !isContextWatchdogReadyToUse(context)) {
                return;
            }
            if (!semaphoreElement || props.isLayoutReady === false) {
                return;
            }
            semaphore.replace({
                "useMultiRootEditor.useEffect": ()=>new LifeCycleElementSemaphore(semaphoreElement, {
                        mount: _initializeEditor,
                        afterMount: {
                            "useMultiRootEditor.useEffect": ({ mountResult })=>{
                                const { onReady } = props;
                                if (onReady && semaphoreElementRef.current !== null) {
                                    onReady(mountResult.instance);
                                }
                            }
                        }["useMultiRootEditor.useEffect"],
                        unmount: {
                            "useMultiRootEditor.useEffect": async ({ element, mountResult })=>{
                                const { onAfterDestroy } = props;
                                try {
                                    await _destroyEditor(mountResult);
                                    element.innerHTML = "";
                                } finally{
                                    if (onAfterDestroy) {
                                        onAfterDestroy(mountResult.instance);
                                    }
                                }
                            }
                        }["useMultiRootEditor.useEffect"]
                    })
            }["useMultiRootEditor.useEffect"]);
            return ({
                "useMultiRootEditor.useEffect": ()=>{
                    forceAssignFakeEditableElements();
                    semaphore.release(false);
                }
            })["useMultiRootEditor.useEffect"];
        }
    }["useMultiRootEditor.useEffect"], [
        props.id,
        props.isLayoutReady,
        context == null ? void 0 : context.status
    ]);
    const _getConfig = ()=>{
        const config = props.config || {};
        if (props.data && config.initialData) {
            console.warn("Editor data should be provided either using `config.initialData` or `data` property. The config value takes precedence over `data` property and will be used when both are specified.");
        }
        return {
            ...config,
            rootsAttributes: attributes
        };
    };
    const onChangeData = useRefSafeCallback({
        "useMultiRootEditor.useRefSafeCallback[onChangeData]": (editor, event)=>{
            const modelDocument = editor.model.document;
            if (!props.disableTwoWayDataBinding) {
                const newData = {};
                const newAttributes = {};
                modelDocument.differ.getChanges().forEach({
                    "useMultiRootEditor.useRefSafeCallback[onChangeData]": (change)=>{
                        let root;
                        /* istanbul ignore else -- @preserve */ if (change.type == "insert" || change.type == "remove") {
                            root = change.position.root;
                        } else {
                            root = change.range.root;
                        }
                        if (!root.isAttached()) {
                            return;
                        }
                        const { rootName } = root;
                        newData[rootName] = editor.getData({
                            rootName
                        });
                    }
                }["useMultiRootEditor.useRefSafeCallback[onChangeData]"]);
                modelDocument.differ.getChangedRoots().forEach({
                    "useMultiRootEditor.useRefSafeCallback[onChangeData]": (changedRoot)=>{
                        if (changedRoot.state) {
                            if (newData[changedRoot.name] !== void 0) {
                                delete newData[changedRoot.name];
                            }
                            return;
                        }
                        const rootName = changedRoot.name;
                        newAttributes[rootName] = editor.getRootAttributes(rootName);
                    }
                }["useMultiRootEditor.useRefSafeCallback[onChangeData]"]);
                if (Object.keys(newData).length) {
                    setData({
                        "useMultiRootEditor.useRefSafeCallback[onChangeData]": (previousData)=>({
                                ...previousData,
                                ...newData
                            })
                    }["useMultiRootEditor.useRefSafeCallback[onChangeData]"]);
                }
                if (Object.keys(newAttributes).length) {
                    setAttributes({
                        "useMultiRootEditor.useRefSafeCallback[onChangeData]": (previousAttributes)=>({
                                ...previousAttributes,
                                ...newAttributes
                            })
                    }["useMultiRootEditor.useRefSafeCallback[onChangeData]"]);
                }
            }
            /* istanbul ignore else -- @preserve */ if (props.onChange) {
                props.onChange(event, editor);
            }
        }
    }["useMultiRootEditor.useRefSafeCallback[onChangeData]"]);
    const onAddRoot = useRefSafeCallback({
        "useMultiRootEditor.useRefSafeCallback[onAddRoot]": (editor, _evt, root)=>{
            const rootName = root.rootName;
            if (!props.disableTwoWayDataBinding) {
                setData({
                    "useMultiRootEditor.useRefSafeCallback[onAddRoot]": (previousData)=>({
                            ...previousData,
                            [rootName]: editor.getData({
                                rootName
                            })
                        })
                }["useMultiRootEditor.useRefSafeCallback[onAddRoot]"]);
                setAttributes({
                    "useMultiRootEditor.useRefSafeCallback[onAddRoot]": (previousAttributes)=>({
                            ...previousAttributes,
                            [rootName]: editor.getRootAttributes(rootName)
                        })
                }["useMultiRootEditor.useRefSafeCallback[onAddRoot]"]);
            }
            setRoots({
                "useMultiRootEditor.useRefSafeCallback[onAddRoot]": (prevRoots)=>(0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f40$ckeditor$2f$ckeditor5$2d$integrations$2d$common$2f$dist$2f$index$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["uniq"])([
                        ...prevRoots,
                        root.rootName
                    ])
            }["useMultiRootEditor.useRefSafeCallback[onAddRoot]"]);
        }
    }["useMultiRootEditor.useRefSafeCallback[onAddRoot]"]);
    const onDetachRoot = useRefSafeCallback({
        "useMultiRootEditor.useRefSafeCallback[onDetachRoot]": (_editor, _evt, root)=>{
            const rootName = root.rootName;
            if (!props.disableTwoWayDataBinding) {
                setData({
                    "useMultiRootEditor.useRefSafeCallback[onDetachRoot]": (previousData)=>{
                        const { [rootName]: _, ...newData } = previousData;
                        return {
                            ...newData
                        };
                    }
                }["useMultiRootEditor.useRefSafeCallback[onDetachRoot]"]);
                setAttributes({
                    "useMultiRootEditor.useRefSafeCallback[onDetachRoot]": (previousAttributes)=>{
                        const { [rootName]: _, ...newAttributes } = previousAttributes;
                        return {
                            ...newAttributes
                        };
                    }
                }["useMultiRootEditor.useRefSafeCallback[onDetachRoot]"]);
            }
            setRoots({
                "useMultiRootEditor.useRefSafeCallback[onDetachRoot]": (prevRoots)=>prevRoots.filter({
                        "useMultiRootEditor.useRefSafeCallback[onDetachRoot]": (root2)=>root2 !== rootName
                    }["useMultiRootEditor.useRefSafeCallback[onDetachRoot]"])
            }["useMultiRootEditor.useRefSafeCallback[onDetachRoot]"]);
        }
    }["useMultiRootEditor.useRefSafeCallback[onDetachRoot]"]);
    const _createEditor = useRefSafeCallback({
        "useMultiRootEditor.useRefSafeCallback[_createEditor]": (initialData, config)=>{
            (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f40$ckeditor$2f$ckeditor5$2d$integrations$2d$common$2f$dist$2f$index$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["overwriteObject"])({
                ...props.rootsAttributes
            }, attributes);
            (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f40$ckeditor$2f$ckeditor5$2d$integrations$2d$common$2f$dist$2f$index$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["overwriteObject"])({
                ...props.data
            }, data);
            (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f40$ckeditor$2f$ckeditor5$2d$integrations$2d$common$2f$dist$2f$index$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["overwriteArray"])(Object.keys(props.data), roots);
            return props.editor.create(initialData, appendAllIntegrationPluginsToConfig(config)).then({
                "useMultiRootEditor.useRefSafeCallback[_createEditor]": (editor)=>{
                    const editorData = editor.getFullData();
                    (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f40$ckeditor$2f$ckeditor5$2d$integrations$2d$common$2f$dist$2f$index$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["overwriteObject"])({
                        ...editorData
                    }, data);
                    (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f40$ckeditor$2f$ckeditor5$2d$integrations$2d$common$2f$dist$2f$index$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["overwriteObject"])({
                        ...editor.getRootsAttributes()
                    }, attributes);
                    (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f40$ckeditor$2f$ckeditor5$2d$integrations$2d$common$2f$dist$2f$index$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["overwriteArray"])(Object.keys(editorData), roots);
                    if (props.disabled) {
                        /* istanbul ignore else -- @preserve */ editor.enableReadOnlyMode(REACT_INTEGRATION_READ_ONLY_LOCK_ID);
                    }
                    const modelDocument = editor.model.document;
                    const viewDocument = editor.editing.view.document;
                    modelDocument.on("change:data", {
                        "useMultiRootEditor.useRefSafeCallback[_createEditor]": (evt)=>onChangeData(editor, evt)
                    }["useMultiRootEditor.useRefSafeCallback[_createEditor]"]);
                    editor.on("addRoot", {
                        "useMultiRootEditor.useRefSafeCallback[_createEditor]": (evt, root)=>onAddRoot(editor, evt, root)
                    }["useMultiRootEditor.useRefSafeCallback[_createEditor]"]);
                    editor.on("detachRoot", {
                        "useMultiRootEditor.useRefSafeCallback[_createEditor]": (evt, root)=>onDetachRoot(editor, evt, root)
                    }["useMultiRootEditor.useRefSafeCallback[_createEditor]"]);
                    viewDocument.on("focus", {
                        "useMultiRootEditor.useRefSafeCallback[_createEditor]": (event)=>{
                            /* istanbul ignore else -- @preserve */ if (props.onFocus) {
                                props.onFocus(event, editor);
                            }
                        }
                    }["useMultiRootEditor.useRefSafeCallback[_createEditor]"]);
                    viewDocument.on("blur", {
                        "useMultiRootEditor.useRefSafeCallback[_createEditor]": (event)=>{
                            /* istanbul ignore else -- @preserve */ if (props.onBlur) {
                                props.onBlur(event, editor);
                            }
                        }
                    }["useMultiRootEditor.useRefSafeCallback[_createEditor]"]);
                    return editor;
                }
            }["useMultiRootEditor.useRefSafeCallback[_createEditor]"]);
        }
    }["useMultiRootEditor.useRefSafeCallback[_createEditor]"]);
    const _destroyEditor = (initializeResult)=>{
        const { watchdog, instance } = initializeResult;
        return new Promise((resolve, reject)=>{
            /* istanbul ignore next -- @preserve */ setTimeout(async ()=>{
                try {
                    if (watchdog) {
                        await watchdog.destroy();
                        return resolve();
                    }
                    if (instance) {
                        await instance.destroy();
                        return resolve();
                    }
                    resolve();
                } catch (e) {
                    console.error(e);
                    reject(e);
                }
            });
        });
    };
    const _initializeEditor = async ()=>{
        if (props.disableWatchdog) {
            const instance = await _createEditor(props.data, _getConfig());
            return {
                instance,
                watchdog: null
            };
        }
        const watchdog = (()=>{
            if (isContextWatchdogReadyToUse(context)) {
                return new EditorWatchdogAdapter(context.watchdog);
            }
            return new props.editor.EditorWatchdog(props.editor, props.watchdogConfig);
        })();
        const totalRestartsRef = {
            current: 0
        };
        watchdog.setCreator(async (_, config)=>{
            const { onAfterDestroy } = props;
            if (totalRestartsRef.current > 0 && onAfterDestroy && editorRefs.instance.current) {
                onAfterDestroy(editorRefs.instance.current);
            }
            const instance = await _createEditor(data, config);
            if (totalRestartsRef.current > 0) {
                semaphore.unsafeSetValue({
                    instance,
                    watchdog
                });
                setTimeout(()=>{
                    /* istanbul ignore next -- @preserve */ if (props.onReady) {
                        props.onReady(watchdog.editor);
                    }
                });
            }
            totalRestartsRef.current++;
            return instance;
        });
        watchdog.on("error", (_, { error, causesRestart })=>{
            const onError = props.onError || console.error;
            onError(error, {
                phase: "runtime",
                willEditorRestart: causesRestart
            });
        });
        await watchdog.create(data, _getConfig()).catch((error)=>{
            const onError = props.onError || console.error;
            onError(error, {
                phase: "initialization",
                willEditorRestart: false
            });
            throw error;
        });
        return {
            watchdog,
            instance: watchdog.editor
        };
    };
    const _getStateDiff = (previousState, newState)=>{
        const previousStateKeys = Object.keys(previousState);
        const newStateKeys = Object.keys(newState);
        return {
            addedKeys: newStateKeys.filter((key)=>!previousStateKeys.includes(key)),
            removedKeys: previousStateKeys.filter((key)=>!newStateKeys.includes(key))
        };
    };
    const _externalSetData = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$index$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["useCallback"])({
        "useMultiRootEditor.useCallback[_externalSetData]": (newData)=>{
            semaphore.runAfterMount({
                "useMultiRootEditor.useCallback[_externalSetData]": ()=>{
                    shouldUpdateEditor.current = true;
                    setData(newData);
                }
            }["useMultiRootEditor.useCallback[_externalSetData]"]);
        }
    }["useMultiRootEditor.useCallback[_externalSetData]"], [
        setData
    ]);
    const _externalSetAttributes = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$index$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["useCallback"])({
        "useMultiRootEditor.useCallback[_externalSetAttributes]": (newAttributes)=>{
            semaphore.runAfterMount({
                "useMultiRootEditor.useCallback[_externalSetAttributes]": ()=>{
                    shouldUpdateEditor.current = true;
                    setAttributes(newAttributes);
                }
            }["useMultiRootEditor.useCallback[_externalSetAttributes]"]);
        }
    }["useMultiRootEditor.useCallback[_externalSetAttributes]"], [
        setAttributes
    ]);
    const toolbarElement = /* @__PURE__ */ __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$index$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["default"].createElement(EditorToolbarWrapper, {
        ref: semaphoreElementRef,
        editor: editorRefs.instance.current
    });
    useInstantEditorEffect(semaphore.current, {
        "useMultiRootEditor.useInstantEditorEffect": ({ instance })=>{
            if (props.disabled) {
                instance.enableReadOnlyMode(REACT_INTEGRATION_READ_ONLY_LOCK_ID);
            } else {
                instance.disableReadOnlyMode(REACT_INTEGRATION_READ_ONLY_LOCK_ID);
            }
        }
    }["useMultiRootEditor.useInstantEditorEffect"], [
        props.disabled
    ]);
    useInstantEditorEffect(semaphore.current, {
        "useMultiRootEditor.useInstantEditorEffect": ({ instance })=>{
            if (shouldUpdateEditor.current) {
                shouldUpdateEditor.current = false;
                const dataKeys = Object.keys(data);
                const attributesKeys = Object.keys(attributes);
                if (!dataKeys.every({
                    "useMultiRootEditor.useInstantEditorEffect": (key)=>attributesKeys.includes(key)
                }["useMultiRootEditor.useInstantEditorEffect"])) {
                    console.error("`data` and `attributes` objects must have the same keys (roots).");
                    throw new Error("`data` and `attributes` objects must have the same keys (roots).");
                }
                const editorData = instance.getFullData();
                const editorAttributes = instance.getRootsAttributes();
                const { addedKeys: newRoots, removedKeys: removedRoots } = _getStateDiff(editorData, data || /* istanbul ignore next -- @preserve: It should never happen, data should be always filled. */ {});
                const modifiedRoots = dataKeys.filter({
                    "useMultiRootEditor.useInstantEditorEffect.modifiedRoots": (rootName)=>editorData[rootName] !== void 0 && JSON.stringify(editorData[rootName]) !== JSON.stringify(data[rootName])
                }["useMultiRootEditor.useInstantEditorEffect.modifiedRoots"]);
                const rootsWithChangedAttributes = attributesKeys.filter({
                    "useMultiRootEditor.useInstantEditorEffect.rootsWithChangedAttributes": (rootName)=>JSON.stringify(editorAttributes[rootName]) !== JSON.stringify(attributes[rootName])
                }["useMultiRootEditor.useInstantEditorEffect.rootsWithChangedAttributes"]);
                const _handleNewRoots = {
                    "useMultiRootEditor.useInstantEditorEffect._handleNewRoots": (roots2)=>{
                        roots2.forEach({
                            "useMultiRootEditor.useInstantEditorEffect._handleNewRoots": (rootName)=>{
                                instance.addRoot(rootName, {
                                    data: data[rootName] || "",
                                    attributes: (attributes == null ? void 0 : attributes[rootName]) || /* istanbul ignore next -- @preserve: attributes should be in sync with root keys */ {},
                                    isUndoable: true
                                });
                            }
                        }["useMultiRootEditor.useInstantEditorEffect._handleNewRoots"]);
                    }
                }["useMultiRootEditor.useInstantEditorEffect._handleNewRoots"];
                const _handleRemovedRoots = {
                    "useMultiRootEditor.useInstantEditorEffect._handleRemovedRoots": (roots2)=>{
                        roots2.forEach({
                            "useMultiRootEditor.useInstantEditorEffect._handleRemovedRoots": (rootName)=>{
                                instance.detachRoot(rootName, true);
                            }
                        }["useMultiRootEditor.useInstantEditorEffect._handleRemovedRoots"]);
                    }
                }["useMultiRootEditor.useInstantEditorEffect._handleRemovedRoots"];
                const _updateEditorData = {
                    "useMultiRootEditor.useInstantEditorEffect._updateEditorData": (roots2)=>{
                        const dataToUpdate = roots2.reduce({
                            "useMultiRootEditor.useInstantEditorEffect._updateEditorData.dataToUpdate": (result, rootName)=>({
                                    ...result,
                                    [rootName]: data[rootName]
                                })
                        }["useMultiRootEditor.useInstantEditorEffect._updateEditorData.dataToUpdate"], /* @__PURE__ */ Object.create(null));
                        instance.data.set(dataToUpdate, {
                            suppressErrorInCollaboration: true
                        });
                    }
                }["useMultiRootEditor.useInstantEditorEffect._updateEditorData"];
                const _updateEditorAttributes = {
                    "useMultiRootEditor.useInstantEditorEffect._updateEditorAttributes": (writer, roots2)=>{
                        roots2.forEach({
                            "useMultiRootEditor.useInstantEditorEffect._updateEditorAttributes": (rootName)=>{
                                Object.keys(attributes[rootName]).forEach({
                                    "useMultiRootEditor.useInstantEditorEffect._updateEditorAttributes": (attr)=>{
                                        instance.registerRootAttribute(attr);
                                    }
                                }["useMultiRootEditor.useInstantEditorEffect._updateEditorAttributes"]);
                                writer.clearAttributes(instance.model.document.getRoot(rootName));
                                writer.setAttributes(attributes[rootName], instance.model.document.getRoot(rootName));
                            }
                        }["useMultiRootEditor.useInstantEditorEffect._updateEditorAttributes"]);
                    }
                }["useMultiRootEditor.useInstantEditorEffect._updateEditorAttributes"];
                setTimeout({
                    "useMultiRootEditor.useInstantEditorEffect": ()=>{
                        instance.model.change({
                            "useMultiRootEditor.useInstantEditorEffect": (writer)=>{
                                _handleNewRoots(newRoots);
                                _handleRemovedRoots(removedRoots);
                                if (modifiedRoots.length) {
                                    _updateEditorData(modifiedRoots);
                                }
                                if (rootsWithChangedAttributes.length) {
                                    _updateEditorAttributes(writer, rootsWithChangedAttributes);
                                }
                            }
                        }["useMultiRootEditor.useInstantEditorEffect"]);
                    }
                }["useMultiRootEditor.useInstantEditorEffect"]);
            }
        }
    }["useMultiRootEditor.useInstantEditorEffect"], [
        data,
        attributes
    ]);
    const editableElements = roots.map((rootName)=>/* @__PURE__ */ __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$index$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["default"].createElement(EditorEditable, {
            key: rootName,
            id: rootName,
            rootName,
            semaphore
        }));
    return {
        editor: editorRefs.instance.current,
        editableElements,
        toolbarElement,
        data,
        setData: _externalSetData,
        attributes,
        setAttributes: _externalSetAttributes
    };
};
const EditorEditable = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$index$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["memo"])((0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$index$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["forwardRef"])(({ id, semaphore, rootName }, ref)=>{
    const innerRef = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$index$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["useRef"])(null);
    (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$index$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["useEffect"])({
        "EditorEditable.useEffect": ()=>{
            let editable;
            let editor;
            semaphore.runAfterMount({
                "EditorEditable.useEffect": ({ instance })=>{
                    if (!innerRef.current) {
                        return;
                    }
                    editor = instance;
                    const { ui, model } = editor;
                    const root = model.document.getRoot(rootName);
                    if (root && editor.ui.getEditableElement(rootName)) {
                        editor.detachEditable(root);
                    }
                    editable = ui.view.createEditable(rootName, innerRef.current);
                    ui.addEditable(editable);
                    instance.editing.view.forceRender();
                }
            }["EditorEditable.useEffect"]);
            return ({
                "EditorEditable.useEffect": ()=>{
                    if (editor && editor.state !== "destroyed" && innerRef.current) {
                        const root = editor.model.document.getRoot(rootName);
                        /* istanbul ignore else -- @preserve */ if (root) {
                            editor.detachEditable(root);
                        }
                    }
                }
            })["EditorEditable.useEffect"];
        }
    }["EditorEditable.useEffect"], [
        semaphore.revision
    ]);
    return /* @__PURE__ */ __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$index$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["default"].createElement("div", {
        key: semaphore.revision,
        id,
        ref: mergeRefs(ref, innerRef)
    });
}));
EditorEditable.displayName = "EditorEditable";
const EditorToolbarWrapper = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$index$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["forwardRef"])(({ editor }, ref)=>{
    const toolbarRef = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$index$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["useRef"])(null);
    (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$index$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["useEffect"])({
        "EditorToolbarWrapper.useEffect": ()=>{
            const toolbarContainer = toolbarRef.current;
            if (!editor || !toolbarContainer) {
                return void 0;
            }
            const element = editor.ui.view.toolbar.element;
            toolbarContainer.appendChild(element);
            return ({
                "EditorToolbarWrapper.useEffect": ()=>{
                    if (toolbarContainer.contains(element)) {
                        toolbarContainer.removeChild(element);
                    }
                }
            })["EditorToolbarWrapper.useEffect"];
        }
    }["EditorToolbarWrapper.useEffect"], [
        editor && editor.id
    ]);
    return /* @__PURE__ */ __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$index$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["default"].createElement("div", {
        ref: mergeRefs(toolbarRef, ref)
    });
});
EditorToolbarWrapper.displayName = "EditorToolbarWrapper";
/**
 * @license Copyright (c) 2003-2025, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-licensing-options
 */ const useIsUnmountedRef = ()=>{
    const mountedRef = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$index$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["useRef"])(false);
    (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$index$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["useEffect"])({
        "useIsUnmountedRef.useEffect": ()=>{
            mountedRef.current = false;
            return ({
                "useIsUnmountedRef.useEffect": ()=>{
                    mountedRef.current = true;
                }
            })["useIsUnmountedRef.useEffect"];
        }
    }["useIsUnmountedRef.useEffect"], []);
    return mountedRef;
};
/**
 * @license Copyright (c) 2003-2025, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-licensing-options
 */ const useAsyncCallback = (callback)=>{
    const [asyncState, setAsyncState] = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$index$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["useState"])({
        status: "idle"
    });
    const unmountedRef = useIsUnmountedRef();
    const prevExecutionUIDRef = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$index$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["useRef"])(null);
    const asyncExecutor = useRefSafeCallback({
        "useAsyncCallback.useRefSafeCallback[asyncExecutor]": async (...args)=>{
            if (unmountedRef.current || (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f40$ckeditor$2f$ckeditor5$2d$integrations$2d$common$2f$dist$2f$index$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["isSSR"])()) {
                return null;
            }
            const currentExecutionUUID = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f40$ckeditor$2f$ckeditor5$2d$integrations$2d$common$2f$dist$2f$index$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["uid"])();
            prevExecutionUIDRef.current = currentExecutionUUID;
            try {
                if (asyncState.status !== "loading") {
                    setAsyncState({
                        status: "loading"
                    });
                }
                const result = await callback(...args);
                if (!unmountedRef.current && prevExecutionUIDRef.current === currentExecutionUUID) {
                    setAsyncState({
                        status: "success",
                        data: result
                    });
                }
                return result;
            } catch (error) {
                console.error(error);
                if (!unmountedRef.current && prevExecutionUIDRef.current === currentExecutionUUID) {
                    setAsyncState({
                        status: "error",
                        error
                    });
                }
            }
            return null;
        }
    }["useAsyncCallback.useRefSafeCallback[asyncExecutor]"]);
    return [
        asyncExecutor,
        asyncState
    ];
};
/**
 * @license Copyright (c) 2003-2025, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-licensing-options
 */ const useAsyncValue = (callback, deps)=>{
    const [asyncCallback, asyncState] = useAsyncCallback(callback);
    useInstantEffect(asyncCallback, deps);
    if (asyncState.status === "idle") {
        return {
            status: "loading"
        };
    }
    return asyncState;
};
/**
 * @license Copyright (c) 2003-2025, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-licensing-options
 */ function useCKEditorCloud(config) {
    const serializedConfigKey = JSON.stringify(config);
    const result = useAsyncValue({
        "useCKEditorCloud.useAsyncValue[result]": async ()=>(0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f40$ckeditor$2f$ckeditor5$2d$integrations$2d$common$2f$dist$2f$index$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["loadCKEditorCloud"])(config)
    }["useCKEditorCloud.useAsyncValue[result]"], [
        serializedConfigKey
    ]);
    if (result.status === "success") {
        return {
            ...result.data,
            status: "success"
        };
    }
    return result;
}
/**
 * @license Copyright (c) 2003-2025, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-licensing-options
 */ const withCKEditorCloud = (config)=>(WrappedComponent)=>{
        const ComponentWithCKEditorCloud = (props)=>{
            var _a, _b;
            const ckeditorCloudResult = useCKEditorCloud(config.cloud);
            switch(ckeditorCloudResult.status){
                case "error":
                    if (!config.renderError) {
                        return "Unable to load CKEditor Cloud data!";
                    }
                    return config.renderError(ckeditorCloudResult.error);
                case "success":
                    return /* @__PURE__ */ __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$index$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["default"].createElement(WrappedComponent, {
                        ...props,
                        cloud: ckeditorCloudResult
                    });
                default:
                    return (_b = (_a = config.renderLoader) == null ? void 0 : _a.call(config)) != null ? _b : null;
            }
        };
        ComponentWithCKEditorCloud.displayName = "ComponentWithCKEditorCloud";
        return ComponentWithCKEditorCloud;
    };
;
 //# sourceMappingURL=index.js.map
}}),
"[project]/node_modules/@ckeditor/ckeditor5-react/dist/index.js [app-client] (ecmascript) <module evaluation>": ((__turbopack_context__) => {
"use strict";

var { g: global, __dirname } = __turbopack_context__;
{
__turbopack_context__.s({});
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$index$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/next/dist/compiled/react/index.js [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f40$ckeditor$2f$ckeditor5$2d$integrations$2d$common$2f$dist$2f$index$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/@ckeditor/ckeditor5-integrations-common/dist/index.js [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f40$ckeditor$2f$ckeditor5$2d$react$2f$dist$2f$index$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__$3c$locals$3e$__ = __turbopack_context__.i("[project]/node_modules/@ckeditor/ckeditor5-react/dist/index.js [app-client] (ecmascript) <locals>");
}}),
"[project]/node_modules/@ckeditor/ckeditor5-react/dist/index.js [app-client] (ecmascript) <exports>": ((__turbopack_context__) => {
"use strict";

var { g: global, __dirname } = __turbopack_context__;
{
__turbopack_context__.s({
    "CKEditor": (()=>__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f40$ckeditor$2f$ckeditor5$2d$react$2f$dist$2f$index$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__$3c$locals$3e$__["CKEditor"]),
    "CKEditorContext": (()=>__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f40$ckeditor$2f$ckeditor5$2d$react$2f$dist$2f$index$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__$3c$locals$3e$__["CKEditorContext"]),
    "loadCKEditorCloud": (()=>__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f40$ckeditor$2f$ckeditor5$2d$integrations$2d$common$2f$dist$2f$index$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["loadCKEditorCloud"]),
    "useCKEditorCloud": (()=>__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f40$ckeditor$2f$ckeditor5$2d$react$2f$dist$2f$index$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__$3c$locals$3e$__["useCKEditorCloud"]),
    "useMultiRootEditor": (()=>__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f40$ckeditor$2f$ckeditor5$2d$react$2f$dist$2f$index$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__$3c$locals$3e$__["useMultiRootEditor"]),
    "withCKEditorCloud": (()=>__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f40$ckeditor$2f$ckeditor5$2d$react$2f$dist$2f$index$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__$3c$locals$3e$__["withCKEditorCloud"])
});
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f40$ckeditor$2f$ckeditor5$2d$integrations$2d$common$2f$dist$2f$index$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/@ckeditor/ckeditor5-integrations-common/dist/index.js [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f40$ckeditor$2f$ckeditor5$2d$react$2f$dist$2f$index$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__$3c$locals$3e$__ = __turbopack_context__.i("[project]/node_modules/@ckeditor/ckeditor5-react/dist/index.js [app-client] (ecmascript) <locals>");
}}),
"[project]/node_modules/@ckeditor/ckeditor5-react/dist/index.js [app-client] (ecmascript)": ((__turbopack_context__) => {
"use strict";

var { g: global, __dirname } = __turbopack_context__;
{
__turbopack_context__.s({
    "CKEditor": (()=>__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f40$ckeditor$2f$ckeditor5$2d$react$2f$dist$2f$index$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__$3c$exports$3e$__["CKEditor"]),
    "CKEditorContext": (()=>__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f40$ckeditor$2f$ckeditor5$2d$react$2f$dist$2f$index$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__$3c$exports$3e$__["CKEditorContext"]),
    "loadCKEditorCloud": (()=>__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f40$ckeditor$2f$ckeditor5$2d$react$2f$dist$2f$index$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__$3c$exports$3e$__["loadCKEditorCloud"]),
    "useCKEditorCloud": (()=>__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f40$ckeditor$2f$ckeditor5$2d$react$2f$dist$2f$index$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__$3c$exports$3e$__["useCKEditorCloud"]),
    "useMultiRootEditor": (()=>__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f40$ckeditor$2f$ckeditor5$2d$react$2f$dist$2f$index$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__$3c$exports$3e$__["useMultiRootEditor"]),
    "withCKEditorCloud": (()=>__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f40$ckeditor$2f$ckeditor5$2d$react$2f$dist$2f$index$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__$3c$exports$3e$__["withCKEditorCloud"])
});
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f40$ckeditor$2f$ckeditor5$2d$react$2f$dist$2f$index$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__$3c$module__evaluation$3e$__ = __turbopack_context__.i("[project]/node_modules/@ckeditor/ckeditor5-react/dist/index.js [app-client] (ecmascript) <module evaluation>");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f40$ckeditor$2f$ckeditor5$2d$react$2f$dist$2f$index$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__$3c$exports$3e$__ = __turbopack_context__.i("[project]/node_modules/@ckeditor/ckeditor5-react/dist/index.js [app-client] (ecmascript) <exports>");
}}),
"[project]/node_modules/@ckeditor/ckeditor5-react/dist/index.js [app-client] (ecmascript, next/dynamic entry)": ((__turbopack_context__) => {

var { g: global, __dirname } = __turbopack_context__;
{
__turbopack_context__.n(__turbopack_context__.i("[project]/node_modules/@ckeditor/ckeditor5-react/dist/index.js [app-client] (ecmascript)"));
}}),
}]);

//# sourceMappingURL=node_modules_%40ckeditor_f76ffa85._.js.map